#include "controller.h"
#include <QDeclarativeView>
#include <QDebug>
#include <QFile>

#ifdef Q_WS_MAEMO_5
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>
#endif

Controller::Controller(QObject *parent) :
    QObject(parent) {
}

void Controller::setView(QmlApplicationViewer *view) {
    m_view = view;
}

void Controller::toggleState() {
    if (!m_view->isFullScreen()) {
        m_view->showFullScreen();
    }
    else {
        m_view->showMaximized();
    }
}

void Controller::setOrientation(const QString &orient) {
    if (orient == "Automatic") {
        m_view->setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    }
    else if (orient == "Landscape") {
        m_view->setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape);
    }
    else if (orient == "Portrait") {
        m_view->setOrientation(QmlApplicationViewer::ScreenOrientationLockPortrait);
    }
}

void Controller::minimize() {
#ifdef Q_WS_MAEMO_5
    QDBusConnection bus = QDBusConnection::sessionBus();

    QDBusMessage message = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    bus.send(message);
#endif
}

void Controller::setMediaPlayer(const QString &player) {
    mediaPlayer = player.toLower().replace(" ", "");
}

bool Controller::kmPlayerInstalled() {
    bool isInstalled = false;
    if ((QFile::exists("/opt/kmplayer/bin/kmplayer")) || (QFile::exists("/usr/bin/kmplayer"))) {
        isInstalled = true;
    }
    return isInstalled;
}

bool Controller::xTubeInstalled() {
    bool isInstalled = false;
    if (QFile::exists("/opt/usr/share/qmltube/qml/qmltube/xtube.js")) {
        isInstalled = true;
    }
    return isInstalled;
}

void Controller::playVideo(const QString &url) {
#ifdef Q_WS_MAEMO_5
    //    qDebug() << url;
    minimize();
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.nokia." + mediaPlayer, "/com/nokia/" + mediaPlayer, "com.nokia." + mediaPlayer, bus);
    dbus_iface.call("mime_open", url);
#endif
}

void Controller::deleteVideo(const QString &path) {
    if (QFile::exists(path)) {
        if (QFile::remove(path)) {
            emit alert("Video deleted from device");
        }
        else {
            emit alert("Unable to delete video");
        }
    }
    else {
        emit alert("Video not found");
    }
}
