import QtQuick 1.0

Item {
    id: menu

    property alias pencilOn : pencilButton.buttonOn

    signal pencilClicked
    signal userInfoClicked
    signal downloadClicked
    signal favouriteClicked
    signal addToPlaylistClicked

    width: parent.width
    height: menu.state == "portrait" && pencilButton.buttonOn ? 120 : 60
    anchors.bottom: parent.bottom

    Rectangle {
        id: background

        anchors.fill: menu
        gradient: Gradient {
            GradientStop { position: 0.0; color: activeColor }
            GradientStop { position: 0.7; color: activeColorLow }
        }
        smooth: true
    }

    Grid {
        id: buttonGrid

        anchors.horizontalCenter: menu.horizontalCenter
        rows: 2
        columns: 6

        move: Transition {
            NumberAnimation { properties: "x", "y"; easing.type: Easing.OutQuart; duration: 500 }
        }

        MenuButton {
            id: userInfoButton
            icon: "ui-images/infoicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: userInfoClicked()
            }
        }

        MenuButton {
            id: pencilButton

            icon: "ui-images/pencilicon.png"
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: pencilClicked()
            }
        }

        MenuButton {
            id: downloadButton
            icon: "ui-images/downloadicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false
            visible: pencilButton.buttonOn

            Connections {
                onButtonClicked: downloadClicked()
            }
        }

        MenuButton {
            id: favouriteButton
            icon: "ui-images/favouritesicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false
            visible: pencilButton.buttonOn

            Connections {
                onButtonClicked: favouriteClicked()
            }
        }

        MenuButton {
            id: playlistButton
            icon: "ui-images/playlistsicon.png"
            visible: pencilButton.buttonOn
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: addToPlaylistClicked()
            }
        }
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: buttonGrid; columns: 3 }
    }
}

