import QtQuick 1.0

Item {
    id: menu

    signal newPlaylistClicked

    width: parent.width
    height: 60

    Rectangle {
        id: background

        anchors.fill: menu
        gradient: Gradient {
            GradientStop { position: 0.0; color: activeColor }
            GradientStop { position: 0.7; color: activeColorLow }
        }
        smooth: true
    }

    Row {
        anchors.horizontalCenter: menu.horizontalCenter

        MenuButton {
            id: newPlaylistButton
            icon: "ui-images/addicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: newPlaylistClicked()
            }
        }
    }
}
