import QtQuick 1.0

Item {

    property variant video
    property string title

//    signal playClicked(variant video)
    signal infoClicked(variant video)
    signal close

    function setVideo(videoObject) {
        /* Set the dialog properties */

        video = videoObject;
        title = video.title;
    }

    id: dialog
    width: 400
    height: 200

    Rectangle {
        id: background

        color: "black"
        radius: 10
        opacity: 0.5
        width: parent.width; height: parent.height
        border.width: 2
        border.color: activeColor
    }

    PushButton {
        id: playButton

        buttonWidth: 100
        buttonHeight: 100
        icon: "ui-images/playicon.png"
        anchors { verticalCenter: dialog.verticalCenter; left: dialog.left; margins: 25 }

        Connections {
            onButtonClicked: {
                Controller.playVideo(video.playerUrl); //playClicked([video]);
                close();
            }
        }
    }

    PushButton {
        id: downloadButton

        buttonWidth: 100
        buttonHeight: 100
        icon: "ui-images/downloadicon.png"
        iconWidth: 60
        iconHeight: 60
        anchors { horizontalCenter: dialog.horizontalCenter; verticalCenter: dialog.verticalCenter }

        Connections {
            onButtonClicked: {
                addDownload(video);
                close();
            }
        }
    }

    PushButton {
        id: infoButton

        buttonWidth: 100
        buttonHeight: 100
        icon: "ui-images/infoicon.png"
        iconWidth: 68
        iconHeight: 68
        anchors { verticalCenter: dialog.verticalCenter; right: dialog.right; margins: 25 }

        Connections {
            onButtonClicked: {
                infoClicked(video);
                close();
            }
        }
    }

    Text {
        id: titleText

        width: dialog.width
        anchors { top: dialog.top; left: dialog.left; right: dialog.right; margins: 10 }
        elide: Text.ElideRight
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: smallFontSize
        color: "white"
        text: title
    }
}
