function getDatabase() {
    return openDatabaseSync("cuteTube", "0.1", "Settings", 100000);
}

function getAccount(username) {
    /* Retreive an existing account */

    var db = getDatabase();
    var res = [];
    db.transaction(function(tx) {
                       var rs = tx.executeSql('SELECT * FROM accounts WHERE username = ?;', [ username ]);
                       if (rs.rows.length > 0) {
                           res = [ rs.rows.item(0).username, rs.rows.item(0).password, rs.rows.item(0).isDefault ];
                       }
                       else {
                           res = "unknown";
                       }
                   }
                   );
    //console.log(res);
    return res
}

function getDefaultAccount() {
    /* Retrieve the default account username and password */

    var db = getDatabase();
    var res = "unknown";
    db.transaction(function(tx) {
                       var rs = tx.executeSql('SELECT username, password FROM accounts WHERE isDefault = 1;');
                       if (rs.rows.length > 0) {
                           res = [ rs.rows.item(0).username, rs.rows.item(0).password ];
                       }
                       else {
                           // Fallback if no account is set as default
                           var accounts = getAllAccounts();
                           if (accounts.length > 0) {
                               res = [ accounts[0][0], accounts[0][1] ];
                           }
                       }
                   });
    //console.log(res);
    return res
}

function getAllAccounts() {
    /* Retrieve all accounts from the database */

    var db = getDatabase();
    var res = [];
    db.transaction(function(tx) {
                       var rs = tx.executeSql('SELECT * FROM accounts;');
                       if (rs.rows.length > 0) {
                           for(var i = 0; i < rs.rows.length; i++) {
                               res[i] = [ rs.rows.item(i).username, rs.rows.item(i).password, rs.rows.item(i).isDefault ];
                           }
                       }
                   }
                   );
    //console.log(res);
    return res
}

function setSetting(setting, value) {
    /* Add a new (setting, value) or replace if key (setting) exists */

    var db = getDatabase();
    var res= "";
    db.transaction(function(tx) {
                       var rs = tx.executeSql('INSERT OR REPLACE INTO settings VALUES (?,?);', [ setting, value ]);
                       if (rs.rowsAffected > 0) {
                           res = "OK";
                       }
                       else {
                           res = "Error";
                       }
                   }
                   );
    //console.log(res);
    return res;
}

function getSetting(setting) {
    /* Retrieve the value for the setting argument */

    var db = getDatabase();
    var res = "";
    db.transaction(function(tx) {
                       var rs = tx.executeSql('SELECT value FROM settings WHERE setting=?;', [ setting ]);
                       if (rs.rows.length > 0) {
                           res = rs.rows.item(0).value;
                       }
                       else {
                           res = "unknown";
                       }
                   }
                   );
    //console.log(res);
    return res
}

function getSearches() {
    /* Retrieve all saved searches from the database */

    var db = getDatabase();
    var res = [];
    db.transaction(function(tx) {
                       var rs = tx.executeSql('SELECT * FROM searches;');
                       if (rs.rows.length > 0) {
                           for(var i = 0; i < rs.rows.length; i++) {
                               res[i] = rs.rows.item(i).searchterm;
                           }
                       }
                   }
                   );
    //console.log(res);
    return res
}

function addSearchTerm(searchterm) {
    /* Add a new search term if it does not already exist */

    var db = getDatabase();
    var res = "";
    db.transaction(function(tx) {
                       var rs = tx.executeSql('INSERT OR REPLACE INTO searches VALUES (?);', [ searchterm ]);
                       if (rs.rowsAffected > 0) {
                           res = "OK";
                       }
                       else {
                           res = "Error";
                       }
                   }
                   );
    //console.log(res);
    return res;
}

function getAllArchiveVideos() {
    /* Retrieve all archive videos from the database */

    var db = getDatabase();
    var res = [];
    db.transaction(function(tx) {
                       var rs = tx.executeSql('SELECT * FROM archive;');
                       if (rs.rows.length > 0) {
                           for(var i = 0; i < rs.rows.length; i++) {
                               res[i] = [ rs.rows.item(i).filePath, rs.rows.item(i).title, rs.rows.item(i).thumbnail,
                                         rs.rows.item(i).quality, rs.rows.item(i).isNew ];
                           }
                       }
                   }
                   );
    //console.log(res);
    return res
}






