import Qt 4.7
import "settings.js" as Settings

Item {
    id: widget

    property string _ACTIVE_COLOR_HIGH : "#6382c6"
    property string _ACTIVE_COLOR_LOW : "#3d6be0"
    property string _BACKGROUND_COLOR : "black"
    property string _GRADIENT_COLOR_HIGH : "#524e4e"
    property string _GRADIENT_COLOR_LOW : "black"
    property string _TEXT_COLOR : "white"
    property int _SMALL_FONT_SIZE : 18
    property int _STANDARD_FONT_SIZE : 24
    property int _LARGE_FONT_SIZE : 36

    property string _UPLOADS_FEED : "http://gdata.youtube.com/feeds/api/users/default/uploads?v=2&max-results=50"
    property string _FAVOURITES_FEED : "http://gdata.youtube.com/feeds/api/users/default/favorites?v=2&max-results=50"
    property string _NEW_SUB_VIDEOS_FEED : "http://gdata.youtube.com/feeds/api/users/default/newsubscriptionvideos?v=2&max-results=50"
    property string _MOST_RECENT_FEED : "http://gdata.youtube.com/feeds/api/standardfeeds/most_recent?v=2&max-results=50"
    property string _MOST_VIEWED_FEED : "http://gdata.youtube.com/feeds/api/standardfeeds/most_viewed?v=2&max-results=50&time=today"
    property string archive : "archive"

    property string videoFeed // Holds the current video feed
    property string accessToken // For feeds that require authentication
    property int playbackQuality : 18

    function getWidgetFeeds() {

        var feedOne = Settings.getSetting("widgetFeedOne");
        var feedTwo = Settings.getSetting("widgetFeedTwo");
        var feedThree = Settings.getSetting("widgetFeedThree");
        var feedFour = Settings.getSetting("widgetFeedFour");
        var feedDict = { "_MOST_RECENT_FEED": "ui-images/mostrecenticon.png", "_MOST_VIEWED_FEED": "ui-images/mostviewedicon.png",
            "_FAVOURITES_FEED": "ui-images/favouritesicon.png", "_NEW_SUB_VIDEOS_FEED": "ui-images/subscriptionsicon.png",
            "_UPLOADS_FEED": "ui-images/uploadsicon.png", "archive": "ui-images/downloadicon.png" };

        buttonOne.feed = eval(feedOne);
        buttonOne.icon = feedDict[feedOne];
        buttonTwo.feed = eval(feedTwo);
        buttonTwo.icon = feedDict[feedTwo];
        buttonThree.feed = eval(feedThree);
        buttonThree.icon = feedDict[feedThree];
        buttonFour.feed = eval(feedFour);
        buttonFour.icon = feedDict[feedFour];
    }

    function getAccessToken() {
        var token = Settings.getSetting("ytAccessToken");
        if (token != "unknown") {
            /* Set the access token */

            widget.accessToken = token;
        }
        else {
            /* Hide the favourites/latest sub videos buttons */

            buttonFour.visible = false;
        }
    }

    function search(query) {
        widget.videoFeed = "http://gdata.youtube.com/feeds/api/videos?v=2&max-results=50&safeSearch=none&q=" + encodeURIComponent(query).replace(" ", "+") + "&orderby=relevance";
        getVideoFeed();
    }

    function getVideoFeed() {
        if (videoFeed == "archive") {
            videoList.positionViewAtIndex(0, ListView.Beginning);
        }
        else {
            videoListModel.loading = true;

            var doc = new XMLHttpRequest();
            doc.onreadystatechange = function() {
                if (doc.readyState == XMLHttpRequest.DONE) {
                    var xml = doc.responseText;
                    videoListModel.setXml(xml);

                    videoListModel.loading = false;
                    videoList.positionViewAtIndex(0, ListView.Beginning);
                }
            }
            doc.open("GET", videoFeed);
            if ((widget.videoFeed == widget._FAVOURITES_FEED) || (widget.videoFeed == widget._UPLOADS_FEED) || (widget.videoFeed == widget._NEW_SUB_VIDEOS_FEED)) {
                doc.setRequestHeader("Authorization", "GoogleLogin auth=" + widget.accessToken);
            }
            doc.send();
        }
    }

    function appendVideoFeed() {
        videoListModel.loading = true;

        var startIndex = videoListModel.count + 1;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var xml = doc.responseText;
                videoListModel.appendXml(xml);
            }

            videoListModel.loading = false;
        }
        doc.open("GET", widget.videoFeed + "&start-index=" + startIndex);
        if ((widget.videoFeed == widget._FAVOURITES_FEED) || (widget.videoFeed == widget._UPLOADS_FEED) || (widget.videoFeed == widget._NEW_SUB_VIDEOS_FEED)) {
            doc.setRequestHeader("Authorization", "GoogleLogin auth=" + widget.accessToken);
        }
        doc.send();
    }

    function playVideo(videoUrl) {
        var mediaPlayer = Settings.getSetting("mediaPlayer");
        mediaPlayer = mediaPlayer.toLowerCase().replace(" ", "");
        Controller.playVideo(videoUrl, mediaPlayer);
    }

    width: 390
    height: 340  //380

    onVideoFeedChanged: videoListModel.xml = "";
    onPlaybackQualityChanged: YouTube.setPlaybackQuality(widget.playbackQuality)
    Component.onCompleted: {
        getWidgetFeeds();
        getAccessToken();
    }

    Connections {
        target: YouTube
        onGotVideoUrl: playVideo(videoUrl)
    }

    Rectangle {
        anchors.fill: widget
        color: widget._BACKGROUND_COLOR
        radius: 10
        border.width: 2
        border.color: widget._ACTIVE_COLOR_LOW
        opacity: 0.5
    }

    /*    Rectangle {
        id: searchBar

        height: 40
        anchors { top: widget.top; topMargin: 5; left: widget.left; leftMargin: 10; right: widget.right; rightMargin: 80 }
        color:  "white"
        border.width: 2
        border.color: widget._ACTIVE_COLOR_LOW
        radius: 5

        TextInput {
            id: searchInput

            anchors { fill: parent; margins: 2 }
            focus: true
            font.pixelSize: widget._STANDARD_FONT_SIZE
            selectByMouse: true
            selectionColor: widget._ACTIVE_COLOR_LOW
            Keys.onEnterPressed: {
                if (searchInput.text != "") {
                    search(searchInput.text);
                }
            }
            Keys.onUpPressed: {
                if (videoList.currentIndex > 3) {
                    videoList.currentIndex = videoList.currentIndex - 3;
                }
                else {
                    videoList.currentIndex = 0;
                }
            }
            Keys.onDownPressed: videoList.currentIndex = videoList.currentIndex + 3
        }
    }

    ToolButton {
        id: searchButton

        width: Math.floor(searchBar.width / 6)
        height: 40
        anchors { top: widget.top; topMargin: 5; right: widget.right; rightMargin: 10 }
        icon: "ui-images/searchicon.png"
        iconWidth: 35
        iconHeight: 35
        onButtonClicked: {
            if (searchInput.text != "") {
                search(searchInput.text);
            }
        }
    }
*/

    ToolButton {
        id: cuteTubeButton

        width: 50 //Math.floor(searchBar.width / 6)
        height: 40
        anchors { left: widget.left; leftMargin: 10; top: widget.top; topMargin: 10 /*55*/ }
        icon: videoList.locked ? "ui-images/widgetlocked.png" : "ui-images/cutetubehires.png"
        iconWidth: 35
        iconHeight: 35
        onButtonClicked: {
            if (!videoList.locked) {
                Controller.launchCuteTube();
            }
        }
        onButtonHeld: videoList.locked = !videoList.locked
    }

    Row {
        id: buttonRow

        anchors { left: cuteTubeButton.right; leftMargin: 20; top: cuteTubeButton.top }
        spacing: 10

        ToolButton {
            id: buttonOne

            property string feed

            width: 50 //Math.floor(searchBar.width / 6)
            height: 40
            iconWidth: 35
            iconHeight: 35
            onButtonClicked: {
                widget.videoFeed = buttonOne.feed;
                getVideoFeed();
            }
        }

        ToolButton {
            id: buttonTwo

            property string feed

            width: 50 //Math.floor(searchBar.width / 6)
            height: 40
            iconWidth: 35
            iconHeight: 35
            onButtonClicked: {
                widget.videoFeed = buttonTwo.feed;
                getVideoFeed();
            }
        }

        ToolButton {
            id: buttonThree

            property string feed

            width: 50 //Math.floor(searchBar.width / 6)
            height: 40
            iconWidth: 35
            iconHeight: 35
            onButtonClicked: {
                widget.videoFeed = buttonThree.feed;
                getVideoFeed();
            }
        }

        ToolButton {
            id: buttonFour

            property string feed

            width: 50 //Math.floor(searchBar.width / 6)
            height: 40
            iconWidth: 35
            iconHeight: 35
            onButtonClicked: {
                widget.videoFeed = buttonFour.feed;
                getVideoFeed();
            }
        }
    }

    ToolButton {
        id: qualityButton

        width: 50 //Math.floor(searchBar.width / 6)
        height: 40
        anchors { right: widget.right; rightMargin: 10; top: widget.top; topMargin: 10 /*55*/ }
        icon: (widget.playbackQuality == 5) ? "ui-images/mobileicon.png" : "ui-images/hqicon.png"
        iconWidth: 35
        iconHeight: 35
        onButtonClicked: (widget.playbackQuality == 18) ? widget.playbackQuality = 5 : widget.playbackQuality = 18
    }

    Text {
        id: noResultsText

        anchors.centerIn: widget
        font.pixelSize: widget._STANDARD_FONT_SIZE
        font.bold: true
        color: "white"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No videos found")
        visible: false

        Timer {
            interval: 5000
            running: (!videoListModel.loading) && (videoListModel.count == 0)
            onTriggered: {
                if (videoList.count == 0) {
                    noResultsText.visible = true;
                }
            }
        }
    }

    VideoListModel {
        id: videoListModel

        property bool loading : true

        onLoadingChanged: {
            if (videoListModel.loading) {
                noResultsText.visible = false;
            }
        }
    }

    ListModel {
        id: archiveModel

        function getArchiveVideos() {
            /* Retrieve archive videos and populate the list model */

            var videos = Settings.getAllArchiveVideos();
            for (var i = 0; i < videos.length ; i++) {
                archiveModel.insert(0, { "playerUrl": videos[i][0], "title": videos[i][1],
                                    "thumbnail": videos[i][2] });
            }
        }
    }

    ListView {
        id: videoList

        property bool locked : false // If true, mouse click signals from delegates will be ignored

        anchors { fill: widget; topMargin: 60 /*100*/; bottomMargin: 40; leftMargin: 2; rightMargin: 2 }
        boundsBehavior: Flickable.DragOverBounds
        highlightMoveDuration: 500
        preferredHighlightBegin: 0
        preferredHighlightEnd: 80
        highlightRangeMode: ListView.StrictlyEnforceRange
        cacheBuffer: 800
        interactive: false
        clip: true

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        model: widget.videoFeed == "archive" ? archiveModel : videoListModel
        onModelChanged: {
            if (videoList.model == archiveModel) {
                archiveModel.getArchiveVideos();
            }
            else (archiveModel.clear());
        }

        onCurrentIndexChanged: {
            if (videoList.model == videoListModel) {
                if ((videoList.count - videoList.currentIndex < 10)
                        && (videoList.count - videoList.currentIndex > 6)
                        && (videoList.count < videoListModel.totalResults)
                        && (videoListModel.status == XmlListModel.Ready)) {
                    appendVideoFeed();
                }
            }
        }

        delegate: WidgetDelegate {
            id: delegate

            onPlayClicked: {
                if (!videoList.locked) {
                    videoList.model == archiveModel ? playVideo(playerUrl) : YouTube.getVideoUrl(playerUrl);
                }
            }
        }
    }

    Image {
        id: upButton

        width: 50
        height: 40
        anchors { left: widget.left; leftMargin: Math.floor((widget.width / 4) - (upButton.width / 2)); bottom: widget.bottom }
        source: upMouseArea.pressed ? "ui-images/upicon2.png" : "ui-images/upicon.png"
        sourceSize.width: upButton.width
        sourceSize.height: upButton.height
        smooth: true

        MouseArea {
            id: upMouseArea

            width: Math.floor(widget.width / 2)
            height: upButton.height
            anchors.centerIn: upButton
            enabled: videoList.count > 0
            onClicked: {
                if (videoList.currentIndex > 3) {
                    videoList.currentIndex = videoList.currentIndex - 3;
                }
                else {
                    videoList.currentIndex = 0;
                }
            }
        }
    }

    Image {
        id: downButton

        width: 50
        height: 40
        anchors { right: widget.right; rightMargin: Math.floor((widget.width / 4) - (downButton.width / 2)); bottom: widget.bottom }
        source: downMouseArea.pressed ? "ui-images/downicon2.png" : "ui-images/downicon.png"
        sourceSize.width: downButton.width
        sourceSize.height: downButton.height
        smooth: true

        MouseArea {
            id: downMouseArea

            width: Math.floor(widget.width / 2)
            height: downButton.height
            anchors.centerIn: downButton
            enabled: videoList.count > 0
            onClicked: videoList.currentIndex = videoList.currentIndex + 3
        }
    }

    Rectangle {
        width: 1
        height: 30
        anchors { bottom: widget.bottom; bottomMargin: 5; horizontalCenter: widget.horizontalCenter }
        color: widget._ACTIVE_COLOR_LOW
        opacity: 0.5
    }

}
