#include "controller.h"
#include <QProcess>

#ifdef Q_WS_MAEMO_5
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>
#endif

Controller::Controller(QObject *parent) :
    QObject(parent) {
}

void Controller::playVideo(const QString &url, const QString &mediaPlayer) {
#ifdef Q_WS_MAEMO_5
    if (mediaPlayer == "mplayer") {
        QStringList args;
        args << "-cache" << "4096" << "-fs" << url;
        QProcess *player = new QProcess();
        connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start("/usr/bin/mplayer", args);
    }
    else {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + mediaPlayer, "/com/nokia/" + mediaPlayer, "com.nokia." + mediaPlayer, bus);
        dbus_iface.call("mime_open", url);
    }
#endif

//#ifdef Q_WS_X11
//    QStringList args;
//    args << "-cache" << "4096" << "-fs" << url;
//    QProcess *player = new QProcess();
//    connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
//    player->start("/usr/bin/mplayer", args);
//#endif
}

void Controller::launchCuteTube() {
    QProcess *launcher = new QProcess();
    connect(launcher, SIGNAL(finished(int, QProcess::ExitStatus)), launcher, SLOT(deleteLater()));
    launcher->start("/opt/usr/bin/qmltube");
}


