#include "wiredheadsetadapter.h"

WiredHeadsetAdapter::WiredHeadsetAdapter(QObject *parent) :
    QObject(parent)
{
    QDBusConnection::systemBus().connect( QString(),
                                          QString(),
                                          "org.freedesktop.Hal.Device",
                                          "Condition",
                                          this, SLOT(processSignal(QString, QString)));
}

void WiredHeadsetAdapter::processSignal(QString event, QString state)
{
    if (event == "ButtonPressed")
    {
        if (state == "forward")
        {
            emit nextButtonPressed();
        }
        else if (state == "rewind")
        {
            emit prevButtonPressed();
        }
        else if (state == "play-pause")
        {
            emit toggleButtonPressed();
        }
        else if (state == "phone")
        {
            emit callButtonPressed();
        }
     }
}
