#include "radiostation.h"

RadioStation::RadioStation(QObject *parent) :
    ListItem(parent)
{
}

RadioStation::RadioStation(QString name, QString freq, QString favorite, QObject *parent) :
    ListItem(parent), m_name(name), m_freq(freq), m_favorite(favorite)
{
}

QVariant RadioStation::data(int role) const
{
    switch(role) {
        case NameRole:    return name();
        case FreqRole:    return freq();
        case FavoriteRole:      return favorite();
        default:    return QVariant();
        }
}

QHash<int, QByteArray> RadioStation::roleNames() const
{
      QHash<int, QByteArray> names;
      names[NameRole] = "name";
      names[FreqRole] = "freq";
      names[FavoriteRole] = "favorite";
      return names;
}

void RadioStation::setValues(QString name, QString freq, QString favorite)
{
    m_name = name;
    m_freq = freq;
    m_favorite = favorite;

    emit dataChanged();
}
