#ifndef QMLAPPLICATIONVIEWER_H
#define QMLAPPLICATIONVIEWER_H

#include "qtextstream.h"
#include <QDebug>
#include <QtDeclarative/QDeclarativeView>
#include <QDBusConnection>
#include <QDesktopWidget>
#include <QKeyEvent>


#include <QtCore/QDir>
#include <QtCore/QFileInfo>
#include <QtGui/QApplication>
#include <QtDeclarative/QDeclarativeComponent>
#include <QtDeclarative/QDeclarativeEngine>
#include <QtDeclarative/QDeclarativeContext>
#include <QDBusMessage>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xdamage.h>
#include <X11/extensions/Xcomposite.h>

#include <QX11Info>

#include "imageprovider.h"


class QmlApplicationViewer : public QDeclarativeView
{
    Q_OBJECT

public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit QmlApplicationViewer(QWidget *parent = 0);
    virtual ~QmlApplicationViewer();

    static QmlApplicationViewer *create();

    void setMainQmlFile(const QString &file);
    void addImportPath(const QString &path);

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();
    void changeEvent(QEvent *event);
    bool _isVisible;

    Q_INVOKABLE QVariant windowId();

    Window statusArea;
    ImageProvider *imageProvider;
    bool isKeyboardOpen;
    QString pendingOrientation;
    bool isPortrait;

signals:
    void updateStatusAreaSignal(int wId);

public slots:
    void updateStatusArea();
    void minimize();  
    void showStatusMenu();

private slots:

    void findStatusWindows();
    Atom getWindowType(const Window &wId);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void onDBusOrientationChanged(const QString &orientation);
    void onKeyboardSlideChanged();
    void onOrientationChanged();
    void onImageReady();

private:
    class QmlApplicationViewerPrivate *d;

    Atom _HILDON_WM_WINDOW_TYPE_STATUS_AREA;
    Atom _NET_WM_WINDOW_TYPE;
    bool isPressed;

};

QApplication *createApplication(int &argc, char **argv);

#endif // QMLAPPLICATIONVIEWER_H
