import QtQuick 1.1

Item {
    id: rec1
    z: 1
    anchors.fill: parent
    property alias stationName: tx2.text
    property int i: 0
    onVisibleChanged: {
        if (visible == true)
            ++i
        tx2.forceActiveFocus()

        tx2.text = stimer.interval/60000
    }
    MouseArea {
        anchors.fill: parent
        onClicked: rec1.visible = false
    }

    Item {
        z: 100
        id: it2
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: parent.top
        anchors.topMargin: radioPage.height/4
        width: 430
        height: 200
        onVisibleChanged: tx2.forceActiveFocus()
        MouseArea {
            anchors.fill: parent
        }


        Text {
            id: barT
            z: 10
            color: "white"
            font.pixelSize: 20
            text: "Sleep timer"
            anchors {
                horizontalCenter: parent.horizontalCenter
                top: parent.top
                topMargin: 2
            }

        }

        Rectangle {
            anchors.fill: it2
            color: "black"
            opacity: 0.7
            border.color: "white"
            radius: 4
        }
        Rectangle {
            anchors.fill: it2
            color: "transparent"
            opacity: 0.6
            border.color: "white"
            radius: 4
        }
        Rectangle {
            id: rectangle1
            width: 200
            height: 40
            y: 10
            anchors.horizontalCenter: parent.horizontalCenter
            color: "black"
            border.color: "white"
            radius: 8
            opacity: 0.15
        }
        TextEdit {
            id: tx2
            focus: true
            anchors {
                horizontalCenter: parent.horizontalCenter
                top: parent.top
                topMargin: 60
            }
            text: stimer.interval/60000
            color: "white"
            font.pixelSize: 20
        }
        Row {
            anchors {
                bottom: parent.bottom
                bottomMargin: 10
                horizontalCenter: parent.horizontalCenter
            }
            spacing: 5
            MyButton {
                text: "Start"
                onClicked: {
                    stimer.interval = tx2.text*60000
                    barT.text = "Sleep timer: "+ stimer.interval/60000
                    stimer.start()
                }
            }
            MyButton {
                text: "Stop"
                onClicked: {
                    barT.text = "Sleep timer"
                    console.log(stimer.interval)
                    stimer.stop()
                }
            }
        }

    }
    Timer {
        id: stimer
        interval: 60000 * 30
        onTriggered: {
            Qt.quit()
        }
    }
}
