import QtQuick 1.1

Item {
    id: root
    width: 90
    height: 70

    property alias freqText: freq.text
    property alias border: rec1.border
    signal clicked()
    signal hold()

    Rectangle {
        id: rec1
        anchors.fill: parent
        border.color: "orange"
        radius: 4
        opacity: 0.4
        smooth: true
        gradient: Gradient {
        GradientStop { position: 0; color: "#55000000" }
        GradientStop { position: 0.3; color: "#dd333333" }
        GradientStop { position: 0.99; color: "#55000000" }
     }
    }

    Rectangle {
        anchors.fill: parent
        z: -50
        opacity: 0.5
        gradient: Gradient {
            GradientStop { position: 0; color: "transparent" }
            GradientStop { position: 0.5; color: "#ffffffff" }
            GradientStop { position: 0.99; color: "transparent" }
        }
        visible: mouseArea.pressed
    }

    Text {
        id: freq
        anchors.centerIn: root
       // text: "99200"
        font.pointSize: 18
        color: "white"
        font.family: digital7Font.name

    }

    MouseArea {
             id: mouseArea
             anchors.fill: parent
             onClicked: {
                 root.clicked()
                 //radio.setFreq(freq.text)

             }
             onPressAndHold: {
                 root.hold()
                 //freq.text = radio.getFreq()
             }
    }

    states: [
        State {
            name: "pressed"
            when: mouseArea.pressed == true
            PropertyChanges {
                target: root
                opacity: .6
            }
        }
    ]
}


//import QtQuick 1.0

//Rectangle {
//    id: root
//    width: 90
//    height: 70

//    property alias freqText: freq.text
//    signal clicked()
//    signal hold()

//    gradient: Gradient {
//        GradientStop { position: 0; color: "#55000000" }
//        GradientStop { position: 0.3; color: "#dd333333" }
//        GradientStop { position: 0.99; color: "#55000000" }
//    }

//    Rectangle {
//        anchors.fill: parent
//        z: -50
//        gradient: Gradient {
//            GradientStop { position: 0; color: "#00ffffff" }
//            GradientStop { position: 0.3; color: "#ffffffff" }
//            GradientStop { position: 0.99; color: "#00ffffff" }
//        }
//        visible: mouseArea.pressed
//    }

//    Text {
//        id: freq
//        anchors.centerIn: root
//        text: "99200"
//        font.pointSize: 18
//        color: "white"
//        font.family: digital7Font.name

//    }

//    MouseArea {
//             id: mouseArea
//             anchors.fill: parent
//             onClicked: {
//                 root.clicked()
//                 //radio.setFreq(freq.text)

//             }
//             onPressAndHold: {
//                 root.hold()
//                 //freq.text = radio.getFreq()
//             }
//    }

//    states: [
//        State {
//            name: "pressed"
//            when: mouseArea.pressed == true
//            PropertyChanges {
//                target: root
//                opacity: .6
//            }
//        }
//    ]
//}
