import QtQuick 1.1

Item {
    width: isPortrait ? 480 : 800
    height: 56
//    fillMode: Image.Stretch
//    smooth: true
//    source: "file://etc/hildon/theme/images/wmTitleBar.png"

//    MouseArea {
//        anchors.fill: parent
//    }

    Rectangle {
        anchors.fill: parent
        opacity: 0.5
        color: "black"
    }

    Item {
        x: 0
        id: task
        height: parent.height
        width: isPortrait  ? 80 : 112

        Image {
            id: taskIcon
            source: "file://etc/hildon/theme/images/wmTaskSwitcherIcon.png"
            anchors.centerIn: parent

            MouseArea {
                id: taskArea
                anchors.fill: parent
                onClicked: viewer.minimize();
            }

            states: State {
                name: "pressed"
                when: taskArea.pressed
                PropertyChanges {
                    target: taskIconPressed
                    visible: true
                }
            }
        }
        Image {
            id: taskIconPressed
            source: "file://etc/hildon/theme/images/wmTaskSwitcherIconPressed.png"
            visible: false
            anchors.centerIn: parent
        }
        Image {
            id: separator
            anchors{
                top: parent.top; bottom: parent.bottom; right: parent.right
            }
            source: "file://etc/hildon/theme/images/wmSeparator.png"
        }
    }

    Image {
        id: statusAreaImage
        anchors.left: task.right
        cache: false
        property int wid:  0

        MouseArea {
            anchors.fill: parent
            onClicked: viewer.showStatusMenu();
        }

        Connections {
            target: viewer
            onUpdateStatusAreaSignal: {
                statusAreaImage.source = ""
                statusAreaImage.source = "image://imageProvider/"+ wId
            }
        }
    }


    Image {
        id: separator1
        anchors{
            top: parent.top; bottom: parent.bottom; left: statusAreaImage.right
        }
        source: "file://etc/hildon/theme/images/wmSeparator.png"
    }


    Rectangle {
        width: 3
        height: isPortrait ? 150 : 360
        anchors {
            horizontalCenterOffset: 120
            top: parent.top
            topMargin: isPortrait ? -78 : -182
            horizontalCenter: parent.horizontalCenter
        }
        radius: 10
        opacity: 0.7
        rotation: -90
        gradient: Gradient {
            GradientStop {
                position: 0.00
                color: "transparent"
            }
            GradientStop {
                position: 0.5
                color: "lightblue"
            }
            GradientStop {
                position: 1.00
                color: "transparent"
            }
        }
    }


    Text {
        anchors {
            verticalCenter: parent.verticalCenter
            left: separator1.right
            leftMargin: 20
            right: close.left
        }    
           // wrapMode: Text.WrapAnywhere
            text: "QML Radio"
            color: "white"
            font.pixelSize: 25
    }

    Item {
        id: close
        height: parent.height
        anchors.right: parent.right

        width: isPortrait  ? 80 : 112
        Image {
            id: closeButton
            z: 11
            source: "file://etc/hildon/theme/images/wmCloseIcon.png"
            anchors.centerIn: parent
            MouseArea {
                id: closeArea
                anchors.fill: parent
                onClicked: viewer.close()
            }
//            states: State {
//                name: "pressed"
//                when: closeArea.pressed
//                PropertyChanges {
//                    target: closeButtonPressed
//                    visible: true
//                }
//            }
        }
        Image {
            id: separator2
            anchors{
                top: parent.top; bottom: parent.bottom; left: parent.left
            }
            source: "file://etc/hildon/theme/images/wmSeparator.png"
        }
       /* Image {
            z: 10
            id: closeButtonPressed
            source: "file://etc/hildon/theme/images/wmRightButtonPressed.png"
            visible: false
            anchors.centerIn: parent
            width: isPortrait  ? 80 : 112
        } */
    }


}
