// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item {
    id: item1
    width: parent.width
    height: 480
    Rectangle {
        id: listMenu1
        width: parent.width
        height: 400
        color: "black"
        opacity: 0.8
    }

    Item {
        id: item2
        anchors.fill: listMenu1
        Text {
            id: l1
            text: qsTr("Settings")
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 50
            font.pointSize: 30
            font.family: digital7Font.name
            color: "white"
            smooth: true
            opacity: rootArea.l1 ? 1 : 0.2
        }
        Text {
            id: l2
            text: isHildon ? (fmRadio.active ? "Stop Radio" : "Start Radio") : qsTr(
                                 "Start/Stop Radio")
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: l1.top
            anchors.bottomMargin: 50
            font.pointSize: 30
            color: "white"
            font.family: digital7Font.name
            smooth: true
            opacity: rootArea.l2 ? 1 : 0.2
        }
        Text {
            id: l3
            text: "Toggle Speakers"
            anchors.bottom: l2.top
            anchors.bottomMargin: 50
            font.pointSize: 30
            color: "white"
            smooth: true
            font.family: digital7Font.name
            opacity: rootArea.l3 ? 1 : 0.2
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Rectangle {
        id: topBar
        width: parent.width
        height: 80
        anchors.top: listMenu1.bottom
        gradient: Gradient {
            GradientStop {
                position: 0.00
                color: "transparent"
            }
            GradientStop {
                position: 0.40
                color: "#add8e6"
            }
            GradientStop {
                position: 0.60
                color: "#add8e6"
            }
            GradientStop {
                position: 1.00
                color: "transparent"
            }
        }
        opacity: 0.2
    }

    HildonBar {
        anchors {
            bottom: parent.bottom
            bottomMargin: 20
        }

        z: 20
        id: topBarf
    }

}
