#include "keypadonhelper.h"

//http://talk.maemo.org/showthread.php?t=70405
//http://talk.maemo.org/showthread.php?t=67917

KeypadOnHelper::KeypadOnHelper(QObject *parent) :
    QObject(parent)
{
    _unpauseKeys = QDBusMessage::createMethodCall("com.nokia.mce",
                                                  "/com/nokia/mce/request",
                                                  "com.nokia.mce.request",
                                                  "req_keypad_off_pause");
    QDBusConnection::systemBus().connect("",
                                         "/com/nokia/mce/signal",
                                         "com.nokia.mce.signal",
                                         "tklock_mode_ind", this, SLOT(onLockChanged(QString)));

    unpauseTimer = new QTimer(this);
    unpauseTimer->setInterval(55000);
    connect(unpauseTimer, SIGNAL(timeout()), this, SLOT(unpauseKeys()));
}

void KeypadOnHelper::onLockChanged(QString msg)
{
    if(msg == "locked")
    {
        unpauseKeys();
        unpauseTimer->start();
    }
    else if(msg == "unlocked")
    {
        unpauseTimer->stop();
    }
}

void KeypadOnHelper::unpauseKeys()
{
    QDBusConnection::systemBus().call(_unpauseKeys);
}

