﻿import QtQuick 1.1

Item {
    id: settingsPage
    anchors.fill: parent
    visible: false
    opacity: 0

    function show()
    {
        visible = true
        opacity = 1
    }
    Behavior on opacity {
        PropertyAnimation {
        }
    }
    MouseArea {
        anchors.fill: parent
        onPressed: {
            parent.opacity = 0
            hideTimer.running = true
        }
    }
    Item {
        z: 100
        id: b2
        anchors {
            right: parent.right
            rightMargin: 20
            left: parent.left
            leftMargin: 20
            top: parent.top
            topMargin: parent.height / 8
            bottom: parent.bottom
            bottomMargin: parent.height / 8
        }

        Rectangle {
            anchors.fill: parent
            color: "black"
            radius: 5
            opacity: 0.8
        }
        Rectangle {
            anchors.fill: parent
            color: "transparent"
            radius: 5
            opacity: 0.4
            border.color: "lightblue"
        }
        Rectangle {
            anchors.top: bar.bottom
            anchors.topMargin: -10
            width: parent.width
            color: "lightblue"
            height: 1
            opacity: 0.2
        }

        Bar {
            z: 10
            id: bar
            text: "Settings"
        }

        Flickable {
            anchors.top: bar.bottom
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: parent.bottom

            contentHeight: settingsColumn.height

            clip: true

            Column {
                id: settingsColumn
                anchors.fill: parent
                spacing: 5

//                Switcher {
//                    id: radioActiveAtStartupSwitch
//                    text: "Play Radio at startup"
//                    checked: mainPage.radioActiveAtStartup
//                    onSwitchChecked: {
//                        Settings.setValue("radioActiveAtStartup", checked)
//                        mainPage.radioActiveAtStartup = checked
//                    }
//                }

//                Switcher {
//                    visible: radioActiveAtStartupSwitch.checked
//                    text: "Resume last freq at startup"
//                    checked: Settings.value("resumeLastFreqAtStartup", true)
//                    onSwitchChecked: {
//                        Settings.setValue("resumeLastFreqAtStartup", checked)
//                    }
//                }

                Switcher {
                    text: "Show background"
                    checked: mainPage.showBackground
                    onSwitchChecked: {
                        Settings.setValue("showBackground", checked)
                        mainPage.showBackground = checked
                    }
                }

//                Switcher {
//                    text: "Disable Bluetooth at close"
//                    checked: mainPage.disabledBluetoothAtClose
//                    onSwitchChecked: {
//                        Settings.setValue("disabledBluetoothAtClose", checked)
//                        mainPage.disabledBluetoothAtClose = checked
//                    }
//                }
            }
        }
    }
    Timer {
        id: hideTimer
        interval: 200
        onTriggered: {
            visible = false
        }
    }
}




//import QtQuick 1.1

//Page {
//    id: settingsPage
//    orientationLock: PageOrientation.LockPortrait
//    tools: ToolBarLayout {
//             id: settingsPageTools
//             ToolIcon { iconId: "toolbar-back"; onClicked: pageStack.pop() }
//    }

//    Header {
//        id: header
//        color: "transparent"
//        text: "Settings"
//        textColor: theme.inverted ? "white" : "black"
//    }

//    HorizontalDelimiter {
//        y: 73
//    }

//    Flickable {
//        anchors.top: header.bottom
//        anchors.left: parent.left
//        anchors.right: parent.right
//        anchors.bottom: parent.bottom

//        contentHeight: settingsColumn.height

//        clip: true

//        Column {
//            id: settingsColumn
//            //anchors.fill: parent
//            spacing: 5


//            HorizontalDelimiter {

//            }


//            SwitchOption {
//                id: radioActiveAtStartupSwitch
//                text: "Play Radio at startup"
//                checked: mainPage.radioActiveAtStartup
//                onSwitchChecked: {
//                    Settings.setValue("radioActiveAtStartup", checked)
//                    mainPage.radioActiveAtStartup = checked
//                }
//            }

//            SwitchOption {
//                enabled: radioActiveAtStartupSwitch.checked
//                text: "Resume last freq at startup"
//                checked: Settings.value("resumeLastFreqAtStartup", true)
//                onSwitchChecked: {
//                    Settings.setValue("resumeLastFreqAtStartup", checked)
//                }
//            }

//            SwitchOption {
//                text: "Show background"
//                checked: mainPage.showBackground
//                onSwitchChecked: {
//                    Settings.setValue("showBackground", checked)
//                    mainPage.showBackground = checked
//                }
//            }

//            HorizontalDelimiter {

//            }

//            Label {
//                anchors.left: parent.left
//                anchors.leftMargin: 15
//                text: "Bluetooth controls:"
//            }

//            ButtonColumn {
//                anchors.left: parent.left
//                anchors.right: parent.right
//                anchors.leftMargin: 50
//                anchors.rightMargin: 50

//                Button {
//                    id: button00
//                    text: "Saved stations list"
//                    onClicked: {
//                        Settings.setValue("bluetoothControlChoice", 0)
//                        mainPage.bluetoothControlChoice = 0
//                    }
//                }

//                Button {
//                    id: button01
//                    text: "Stations seeking"
//                    onClicked: {
//                        Settings.setValue("bluetoothControlChoice", 1)
//                        mainPage.bluetoothControlChoice = 1
//                    }
//                }

//                Button {
//                    id: button02
//                    text: "Frequency"
//                    onClicked: {
//                        Settings.setValue("bluetoothControlChoice", 2)
//                        mainPage.bluetoothControlChoice = 2
//                    }
//                }


//                Component.onCompleted: {
//                    switch ( mainPage.bluetoothControlChoice ) {
//                    case 0: button00.checked = true; break;
//                    case 1: button01.checked = true; break;
//                    case 2: button02.checked = true; break;
//                    }
//                }
//            }


//            HorizontalDelimiter { }

//            SwitchOption {
//                text: "Use custom volume keys sets"
//                checked: mainPage.customVolumeKeysSet
//                onSwitchChecked: {
//                    Settings.setValue("customVolumeKeysSet", checked)
//                    mainPage.customVolumeKeysSet = checked
//                }
//            }

//            Label {
//                anchors.left: parent.left
//                anchors.leftMargin: 15
//                text: "Volume clicks control:"
//            }

//            ButtonColumn {
//                anchors.left: parent.left
//                anchors.right: parent.right
//                anchors.leftMargin: 50
//                anchors.rightMargin: 50

//                Button {
//                    id: volKeyBut0
//                    text: "Volume"
//                    onClicked: {
//                        Settings.setValue("volumeClickedChoice", 0)
//                        mainPage.volumeClickedChoice = 0
//                    }
//                }

//                Button {
//                    id: volKeyBut1
//                    text: "Saved stations list"
//                    onClicked: {
//                        Settings.setValue("volumeClickedChoice", 1)
//                        mainPage.volumeClickedChoice = 1
//                    }
//                }

//                Button {
//                    id: volKeyBut2
//                    text: "Stations seeking"
//                    onClicked: {
//                        Settings.setValue("volumeClickedChoice", 2)
//                        mainPage.volumeClickedChoice = 2
//                    }
//                }

//                Button {
//                    id: volKeyBut3
//                    text: "Frequency"
//                    onClicked: {
//                        Settings.setValue("volumeClickedChoice", 3)
//                        mainPage.volumeClickedChoice = 3
//                    }
//                }


//                Component.onCompleted: {
//                    switch ( mainPage.volumeClickedChoice ) {
//                    case 0: volKeyBut0.checked = true; break;
//                    case 1: volKeyBut1.checked = true; break;
//                    case 2: volKeyBut2.checked = true; break;
//                    case 3: volKeyBut3.checked = true; break;
//                    }
//                }
//            }

//            Label {}

//            Label {
//                anchors.left: parent.left
//                anchors.leftMargin: 15
//                text: "Volume holds control:"
//            }

//            ButtonColumn {
//                anchors.left: parent.left
//                anchors.right: parent.right
//                anchors.leftMargin: 50
//                anchors.rightMargin: 50

//                Button {
//                    id: volKeyHBut0
//                    text: "Saved stations list"
//                    onClicked: {
//                        Settings.setValue("volumeHoldChoice", 0)
//                        mainPage.volumeHoldChoice = 0
//                    }
//                }

//                Button {
//                    id: volKeyHBut1
//                    text: "Stations seeking"
//                    onClicked: {
//                        Settings.setValue("volumeHoldChoice", 1)
//                        mainPage.volumeHoldChoice = 1
//                    }
//                }

//                Component.onCompleted: {
//                    switch ( mainPage.volumeHoldChoice ) {
//                    case 0: volKeyHBut0.checked = true; break;
//                    case 1: volKeyHBut1.checked = true; break;
//                    }
//                }


//            }

//            HorizontalDelimiter { }

//            SwitchOption {
//                text: "Shake control"
//                checked: mainPage.shakeControlActive
//                onSwitchChecked: {
//                    Settings.setValue("shakeControlActive", checked)
//                    mainPage.shakeControlActive = checked
//                }
//            }

//            Label {
//                anchors.left: parent.left
//                anchors.leftMargin: 15
//                text: "Shake X controls:"
//            }

//            ButtonColumn {
//                anchors.left: parent.left
//                anchors.right: parent.right
//                anchors.leftMargin: 50
//                anchors.rightMargin: 50

//                Button {
//                    id: volKeyBut0s
//                    text: "Radio toggle"
//                    onClicked: {
//                        Settings.setValue("shakeControlXChoice", 0)
//                        mainPage.shakeControlXChoice = 0
//                    }
//                }

//                Button {
//                    id: volKeyBut1s
//                    text: "Saved stations list"
//                    onClicked: {
//                        Settings.setValue("shakeControlXChoice", 1)
//                        mainPage.shakeControlXChoice = 1
//                    }
//                }


//                Component.onCompleted: {
//                    switch ( mainPage.shakeControlXChoice ) {
//                    case 0: volKeyBut0s.checked = true; break;
//                    case 1: volKeyBut1s.checked = true; break;
//                    }
//                }
//            }

//            Label {
//                anchors.left: parent.left
//                anchors.leftMargin: 15
//                text: "Shake Y controls:"
//            }

//            ButtonColumn {
//                anchors.left: parent.left
//                anchors.right: parent.right
//                anchors.leftMargin: 50
//                anchors.rightMargin: 50

//                Button {
//                    id: volKeyBut0ss
//                    text: "Radio toggle"
//                    onClicked: {
//                        Settings.setValue("shakeControlYChoice", 0)
//                        mainPage.shakeControlYChoice = 0
//                    }
//                }

//                Button {
//                    id: volKeyBut1ss
//                    text: "Saved stations list"
//                    onClicked: {
//                        Settings.setValue("shakeControlYChoice", 1)
//                        mainPage.shakeControlYChoice = 1
//                    }
//                }


//                Component.onCompleted: {
//                    switch ( mainPage.shakeControlYChoice ) {
//                    case 0: volKeyBut0ss.checked = true; break;
//                    case 1: volKeyBut1ss.checked = true; break;
//                    }
//                }
//            }
//        }

//    }



//}
