#include <QtGui>
#include <QtDeclarative>
#include <QDir>
#include <QCoreApplication>

#include "qmlapplicationviewer.h"

#include "bluetoothheadsetadapter.h"
#include "fmradio.h"
#include "Settings.h"
#include "stationsmanagers.h"
#include "wiredheadsetadapter.h"
#include "keypadonhelper.h"

#include <QDebug>

const QString appVersion = "0.1.3";
const QString OS_Platform = "fremantle";

void sigHandler(int sig)
{
    Q_UNUSED(sig);
    QProcess::execute("/bin/sh", QStringList() << "-c" << "amixer -qc0 cset iface=MIXER,name=\'Input Select\' \"Digital Mic\"; amixer -qc0 cset iface=MIXER,name=\'ADC HPF Cut-off\' 0.0045xFs");
    exit(0);
}

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(createApplication(argc, argv));
    app->setApplicationName("QMLRadio");
    app->setOrganizationName("qmlradio");

    Settings* settings = new Settings(app.data());
    StationsManagers stationsManager;

    qmlRegisterType<BluetoothHeadsetAdapter>("it.ggiovanni88", 1, 0, "BluetoothHeadsetAdapter");
    qmlRegisterType<FMRadio>("it.ggiovanni88", 1, 0, "FMRadio");
    qmlRegisterType<WiredHeadsetAdapter>("it.ggiovanni88", 1, 0, "WiredHeadsetAdapter");
    qmlRegisterType<KeypadOnHelper>("it.ggiovanni88", 1, 0, "KeypadOnHelper");

    QmlApplicationViewer viewer;

#ifdef Q_WS_MAEMO_5
    viewer.setAttribute(Qt::WA_Maemo5AutoOrientation);
    bool isHildon = true;
#else
    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    bool isHildon = false;
#endif

    viewer.setAttribute(Qt::WA_OpaquePaintEvent);
    viewer.setAttribute(Qt::WA_NoSystemBackground);
    viewer.viewport()->setAttribute(Qt::WA_OpaquePaintEvent);
    viewer.viewport()->setAttribute(Qt::WA_NoSystemBackground);

    viewer.rootContext()->setContextProperty("viewer", &viewer);
    viewer.rootContext()->setContextProperty("OS_Platform", QVariant::fromValue(QString(OS_Platform)));
    viewer.rootContext()->setContextProperty("appVersion", QVariant::fromValue(QString(appVersion)));
    viewer.rootContext()->setContextProperty("Settings", settings);
    viewer.rootContext()->setContextProperty("stationsManager", &stationsManager);
    viewer.rootContext()->setContextProperty("stationsModel", stationsManager.getModel());
    viewer.rootContext()->setContextProperty("isHildon", isHildon);
    viewer.rootContext()->setContextProperty("appPath", QCoreApplication::applicationDirPath());

    viewer.setSource(QUrl::fromLocalFile(QString::fromLatin1("/%1/%2").arg(
                                                  QCoreApplication::applicationDirPath(), "qml/main.qml")));

    if(isHildon)
        viewer.showFullScreen();
    else
        viewer.show();

    signal(SIGINT, &sigHandler);
    signal(SIGSEGV, &sigHandler);

    return app->exec();
}
