/*
  http://code.google.com/p/nokia-screensaver/
*/
import QtQuick 1.1

Rectangle {
    id:clock
    Text {
        id: timeText
        color: "white"
        font.pointSize: 20
        //font.bold: true
        //style: Text.Outline
        styleColor: "#FFFFFF"
    }
    Timer {
        id:clocktimer
        triggeredOnStart: true
        running: true
        interval: 1000*30
        repeat: true
        onTriggered: {
            var date = new Date();
            timeText.text = Qt.formatTime(date, "hh:mm");
            clocktimer.interval = 1000*(60 - date.getSeconds()) - date.getMilliseconds();
        }
    }
}
