import QtQuick 1.1
import it.ggiovanni88 1.0

Item {
    id: mainPage
    anchors.fill: parent

    property string themeColor: Settings.value("themeColor", "#112233")
    property int currentListIndex: 0
    property int currentListCount
    property bool toggleSpeaker: false

    property bool showBackground: Settings.value("showBackground", true)
    property int bluetoothControlChoice: Settings.value("bluetoothControlChoice", 0) //0 saved stations - 1 seek - 2 freqUpDown

    property bool customVolumeKeysSet: Settings.value("customVolumeKeysSet", false)
    property int volumeClickedChoice: Settings.value("volumeClickedChoice", 0) // 0 volume - 1 saved stations - 2 seek - 3 freq
    property int volumeHoldChoice: Settings.value("volumeHoldChoice", 0) // 0 saved stations - 1 seek

    property int latestFreq: Settings.value("lastUsedFreq", 87500)


    Image {
        z: 0
        source: "file:/" + appPath +  "/images/carbonBackground.png"
        visible: showBackground
        rotation: isPortrait ? 0 : -90
        anchors.centerIn: parent
    }

    function toggleRadioActive() {
        fmRadio.active = !fmRadio.active
        console.log(fmRadio.active)
    }

    function playPrev() {
        if (currentListIndex == 0) currentListIndex = (currentListCount - 1)
        else currentListIndex--
    }

    function playNext() {
        if (currentListIndex < currentListCount -1 ) currentListIndex++
        else currentListIndex = 0
    }

    KeypadOnHelper {
    }

    Component.onCompleted: {
        pagesPathView.model.append({"sourceF": "file:/" + appPath +  "/qml/RadioPage.qml"})
        pagesPathView.model.append({"sourceF": "file:/" + appPath +  "/qml/StationsPage.qml"})
    }

    PathView {
        id: pagesPathView

        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: parent.bottom

        preferredHighlightBegin: 0.5
        preferredHighlightEnd: 0.5

        model: ListModel {}

        delegate: Item {
            width: pagesPathView.width
            height: pagesPathView.height

            Loader { anchors.fill: parent; source: sourceF }
        }

        path: Path {
            startX: -( pagesPathView.width / 2 )
            startY: (pagesPathView.height / 2)

            PathLine { x: pagesPathView.width/2; y: pagesPathView.height/2; }
            PathLine { x: pagesPathView.width*1.5; y: pagesPathView.height/2; }
        }
    }

    Label {
        id: scanlabel
        visible: false
        text: "Scanning.."
        font.pixelSize: 30
        anchors.centerIn: parent
        horizontalAlignment: Text.AlignHCenter
    }
    Label {
        id: scanplabel
        visible: false
        anchors.top: scanlabel.bottom
        anchors.horizontalCenter: parent.horizontalCenter
        text: "30%"
        horizontalAlignment: Text.AlignHCenter

    }

    FMRadio {
        id: fmRadio

        onScannedStationFound: {
            stationsManager.addStation(name, freq, "false")
        }

        onAutoscanActiveChanged: {
            scanlabel.visible = autoscanActive
            scanplabel.visible = autoscanActive
        }

        onAutoScanPercentageChanged: {
            scanplabel.text = autoScanPercentage + "%"
        }

        onActiveChanged: {
            if(active)
            {
                freq = latestFreq
            }
            else {
                latestFreq = freq
            }
        }

        onDoNext: {
            playNext()
        }
        onDoPrev: {
            playPrev()
        }

        Component.onCompleted:
        {
        }
        Component.onDestruction:
        {
            Settings.setValue("lastUsedFreq", freq)
        }

    }

  /*  BluetoothHeadsetAdapter {
        onToggleButtonPressed: toggleRadioActive()

        onPrevButtonPressed: {
            switch (bluetoothControlChoice) {
            case 0: playPrev(); break;
            case 1: fmRadio.scanDown(); break;
            case 2: fmRadio.freqDown(); break;
            }
        }

        onNextButtonPressed: {
            switch (bluetoothControlChoice) {
            case 0: playNext(); break;
            case 1: fmRadio.scanUp(); break;
            case 2: fmRadio.freqUp(); break;
            }
        }
    } */

    WiredHeadsetAdapter {
        onToggleButtonPressed: toggleRadioActive()

        onPrevButtonPressed: {
            switch (bluetoothControlChoice) {
            case 0: playPrev(); break;
            case 1: fmRadio.scanDown(); break;
            case 2: fmRadio.freqDown(); break;
            }
        }

        onNextButtonPressed: {
            switch (bluetoothControlChoice) {
            case 0: playNext(); break;
            case 1: fmRadio.scanUp(); break;
            case 2: fmRadio.freqUp(); break;
            }
        }

        onCallButtonPressed: console.debug("Call button clicked")
    }

}

