import QtQuick 1.1

Item {
    id: root
    width: 377
    height: 154

    property alias mhText: mhText.text
    property alias khText: khText.text

    Rectangle {
        anchors.fill: parent
        border.color: "#3F9695"
        radius: 4
        opacity: 0.4
        color: "transparent"
//        gradient: Gradient {
//        GradientStop { position: 0; color: "#55000000" }
//        GradientStop { position: 0.3; color: "#dd333333" }
//        GradientStop { position: 0.99; color: "#55000000" }
//    }
}

    Rectangle {
        anchors.fill: parent
        radius: 4
        opacity: 0.1
        color: "white"
    }

    Text {
        id: mhText
        x: 19
        y: 73
        anchors.top: point.bottom
        anchors.topMargin: -80
        font.pixelSize: 109
        color: "white"
        text: "91"
        font.family: digital7Font.name
        verticalAlignment: Text.AlignTop
        anchors.right: point.left
        anchors.rightMargin: -1
        horizontalAlignment: Text.AlignRight
    }

    Text {
        id: khText
        x: 189
        y: 113
        color: "white"
        text: "500"
        font.family: digital7Font.name
        anchors.top: point.bottom
        anchors.topMargin: -40
        z: 0
        scale: 1
        transformOrigin: Item.Center
        anchors.left: point.right
        anchors.leftMargin: 0
        verticalAlignment: Text.AlignBottom
        horizontalAlignment: Text.AlignRight
        font.pixelSize: 56
    }

    Text {
        id: point
        x: 156
        y: 30
        text: "."
        color: "white"
        font.family: digital7Font.name
        font.pixelSize: 105
    }

    Text {
        id: mhSimble
        x: 271
        y: 87
        text: "Mhz"
        font.family: digital7Font.name
        color: "cyan"
        font.pixelSize: 28
    }
    Item {
        width: 60
        height: 30
        anchors {
            left: parent.left
            leftMargin: 2
            bottom: parent.bottom
            bottomMargin: 2
        }
        Text {
            anchors.centerIn: parent
            text: "Autoscan"
            font.family: digital7Font.name
            color: "cyan"
            font.pixelSize: 14
        }
        MouseArea {
            anchors.fill: parent
            onClicked: {
                fmRadio.startAutoScan()
            }
        }
    }

    Item {
        width: 60
        height: 30
        anchors {
            right: parent.right
            rightMargin: 2
            bottom: parent.bottom
            bottomMargin: 2
        }
        Text {
            anchors.centerIn: parent
            text: "Timer"
            font.family: digital7Font.name
            color: "cyan"
            font.pixelSize: 14
        }
        MouseArea {
            anchors.fill: parent
            onClicked: {
                sleepTimer.visible = true
            }
        }
    }


}
