#ifndef STATIONITEM_H
#define STATIONITEM_H

#include <QtCore>
#include "listmodel.h"

class StationItem : public ListItem
{
  Q_OBJECT

public:
  enum Roles {
    NameRole = Qt::UserRole+1,
    FreqRole
  };

public:
  StationItem(QObject *parent = 0): ListItem(parent) {}
  explicit StationItem(const QString &name, const QString &freq, QObject *parent = 0);
  QVariant data(int role) const;
  QHash<int, QByteArray> roleNames() const;
  inline QString id() const { return m_name; }
  inline QString name() const { return m_name; }
  inline QString freq() const { return m_freq; }


private:
  QString m_name;
  QString m_freq;
};

#endif // STATIONITEM_H
