#include "stationitem.h"

StationItem::StationItem(const QString &name, const QString &freq, QObject *parent) :
  ListItem(parent), m_name(name), m_freq(freq)
{

}



QHash<int, QByteArray> StationItem::roleNames() const
{
  QHash<int, QByteArray> names;
  names[NameRole] = "name";
  names[FreqRole] = "freq";
  return names;
}

QVariant StationItem::data(int role) const
{
  switch(role) {
  case NameRole:
    return name();
  case FreqRole:
    return freq();
  default:
    return QVariant();
  }
}
