#ifndef QMLRADIO_H
#define QMLRADIO_H

#include <QtDeclarative>
#include <QObject>
#include <QtMultimediaKit/QRadioTuner>
#include "radio.h"
#include "modelmanager.h"



class QMLRadio : public QObject
{
    Q_OBJECT
public:
    explicit QMLRadio(QObject *parent = 0);
    ~QMLRadio();

    void setRadioProperty(Radio* radio);
    void setModelManagerProperty();


signals:

public slots:
    void setFreqLabel(QString text);


private:
    QObject* qmlObject;
    QDeclarativeView *view;
    Radio* radio;
    ModelManager* modelManager;

    void setConnections();
    void setView();

private slots:
    void onMultitaskButtonClicked();


};

#endif // QMLRADIO_H
