#include "qmlradio.h"


QMLRadio::QMLRadio(QObject *parent) :
    QObject(parent)
{


    radio = new Radio;
    modelManager = new ModelManager;

    setRadioProperty(radio);
    setModelManagerProperty();

    setView();



    setConnections();

}

QMLRadio::~QMLRadio()
{
    qDebug() << "Inside QMLRadio destructor";
    delete modelManager;
    delete radio;
}

void QMLRadio::setConnections()
{
    connect(radio, SIGNAL(freqChanged(QString)), this, SLOT(setFreqLabel(QString)));
    connect(view->engine(), SIGNAL(quit()), qApp, SLOT(quit()));

    QObject *multitaskButton = qmlObject->findChild<QObject*>("multitaskButton");
     if (multitaskButton)
     {
         connect(multitaskButton, SIGNAL(buttonClicked()), this, SLOT(onMultitaskButtonClicked()));
     }

     QObject *swipeArea = qmlObject->findChild<QObject*>("swipeArea");
      if (swipeArea)
      {
          //connect(swipeArea, SIGNAL(swipeDown()), qApp, SLOT(quit()));
          //connect(swipeArea, SIGNAL(swipeUp()), this, SLOT(onMultitaskButtonClicked()));
      }


}

void QMLRadio::setRadioProperty(Radio *radio)
{

}

void QMLRadio::setView()
{
    view = new QDeclarativeView;
    view->rootContext()->setContextProperty("modelManager",  modelManager);
    view->rootContext()->setContextProperty("stationsModel",  modelManager->getModel());
    view->rootContext()->setContextProperty("radio", radio);
    view->setSource(QUrl("qrc:/qml/main.qml"));
    view->setWindowTitle("QML-Radio");
    view->showFullScreen();

    qmlObject = view->rootObject();
}

void QMLRadio::setFreqLabel(QString textFreq)
{
    int freq = textFreq.toInt();
    qDebug() << "in setFreqLabel";
    QVariant text1 = freq/1000;
    QVariant text2 = textFreq.right(3);
    static QObject* frequencyLabel = qmlObject->findChild<QObject*>("frequencyLabel");
    qDebug() << QMetaObject::invokeMethod(frequencyLabel, "setText", Q_ARG(QVariant, text1), Q_ARG(QVariant, text2));
}

void QMLRadio::onMultitaskButtonClicked()
{

    system("dbus-send /com/nokia/hildon_desktop com.nokia.hildon_desktop.exit_app_view");

}



void QMLRadio::setModelManagerProperty()
{

}
