import QtQuick 1.0

Rectangle {
    id: stationsList
    width: 300
    height: 180
    color: "#33000000"

    signal stationPicked(string freq)

    /*ListModel {
        id: stationsModel
         ListElement {
             name: "RTL 102.5"
             freq: "99.2"
         }
         ListElement {
             name: "RMC 101"
             freq: "101.0"
         }
         ListElement {
             name: "RIN"
             freq: "87.6"
         }
         ListElement {
             name: "RTL 102.5"
             freq: "99.2"
         }
         ListElement {
             name: "RMC 101"
             freq: "101.0"
         }
         ListElement {
             name: "RIN"
             freq: "87.6"
         }
         ListElement {
             name: "RTL 102.5"
             freq: "99.2"
         }
         ListElement {
             name: "RMC 101"
             freq: "101.0"
         }
         ListElement {
             name: "RIN"
             freq: "87.6"
         }
         ListElement {
             name: "RTL 102.5"
             freq: "99.2"
         }
         ListElement {
             name: "RMC 101"
             freq: "101.0"
         }
         ListElement {
             name: "RIN"
             freq: "87.6"
         }
     }*/

    Component {
        id: stationsDelegate
        Item {
            id: delegateItem
            width: 300; height: 80
            Column {
                id: stationLabel
                width: 220
                height: 80
                Text {
                    text: name
                    color: "white"
                }
                Text {
                    text: freq
                    color: "white"
                    font.pixelSize: 20
                }
            }

            Item {
                id: deleteButton
                x: 220
                width: 80
                height: 80

                Rectangle {
                    x: 10
                    y: 27
                    width: 40
                    height: 5
                    radius: 5
                    scale: 0.7

                    color: "white"

                }
                MouseArea {
                    anchors.fill: deleteButton;
                    onPressAndHold: {
                        console.debug("Index from qml: " + index)
                        stationsModel.removeRow(index)
                    }
                }
            }

            MouseArea {
                anchors.fill: stationLabel;
                onClicked: stationsList.stationPicked(freq)

            }

            ListView.onAdd: SequentialAnimation {
                             PropertyAction { target: delegateItem; property: "opacity"; value: 0 }
                             NumberAnimation { target: delegateItem; property: "opacity"; to: 1; duration: 250; easing.type: Easing.InOutQuad }
                         }

                         ListView.onRemove: SequentialAnimation {
                             PropertyAction { target: delegateItem; property: "ListView.delayRemove"; value: true }
                             NumberAnimation { target: delegateItem; property: "opacity"; to: 0; duration: 250; easing.type: Easing.InOutQuad }

                             // Make sure delayRemove is set back to false so that the item can be destroyed
                             PropertyAction { target: delegateItem; property: "ListView.delayRemove"; value: false }
                         }
        }

    }

    ListView {
        id: listView
        anchors.bottomMargin: 9
        anchors.topMargin: 9
        anchors.leftMargin: 9
        anchors.rightMargin: 9

        anchors.fill: parent

        model: stationsModel
        delegate: stationsDelegate
        clip: true



    }




}


