import QtQuick 1.0

Rectangle {
    id: button


    property alias text: textItem.text

    width: 160; height: 70
    border.color:  "white"
    border.width: 1
    radius: 8
    //smooth: true

    signal buttonClicked

    color: "#000000ff"

    Rectangle {
        width: button.width; height: button.height
        radius: 8
        z: -2
        gradient: Gradient {
            GradientStop { position: 0; color: "#000000" }
            GradientStop { position: 0.3; color: "#444444" }
            GradientStop { position: 0.99; color: "#000000" }
        }
    }



    Text {
        id: textItem
        anchors.centerIn: parent
        font.pointSize: 20
        color: "white"
    }

    MouseArea {
             id: mouseArea
             anchors.fill: parent
             onClicked: {
                 button.buttonClicked()

             }
    }

    states: State {
             name: "pressed"
             when: mouseArea.pressed == true
             PropertyChanges {
                 target: button
                 opacity: .6
             }
    }
}
