#include "freqwidget.h"
#include <QDebug>

FreqWidget::FreqWidget(const uint &freq_min, const uint &freq_max, const uint &freq, QWidget *parent) :
    QPushButton(parent)
{
    setFixedSize(800, 480);
    setStyleSheet("background-color:transparent;");

    QWidget *widget = new QWidget(this);
    widget->setFixedSize(440, 180);
    widget->setAutoFillBackground(true);
    widget->move((width()-widget->width())/2, 130);
    widget->setStyleSheet(QString("background-color:%1;").arg(QPalette::Window));
    widget->setAttribute(Qt::WA_TransparentForMouseEvents, false);


    spinBox1 = new QSpinBox(widget);
    spinBox1->setGeometry(30, 20, 190, 60);
    spinBox1->setRange(freq_min/1000, freq_max/1000);

    spinBox2 = new QSpinBox(widget);
    spinBox2->setGeometry(spinBox1->x() + spinBox1->width(), spinBox1->y(), 190, 60);
    spinBox2->setRange(0, 90);
    spinBox2->setSingleStep(10);


    QPushButton *button = new QPushButton("Set", widget);
    button->setFixedSize(200, 70);
    button->move((widget->width()-button->width())/2, 100);

    connect(button, SIGNAL(clicked()), this, SLOT(onButtonPressed()));

    setFreq(freq);


    qDebug() << "freq signal: " << ((spinBox1->value()*1000) + (spinBox2->value()*10));
}

void FreqWidget::setFreq(const uint &freq)
{
    spinBox1->setValue(freq/1000);
    spinBox2->setValue((freq%1000)/10);
}

void FreqWidget::onButtonPressed()
{
    hide();
    emit freqChanged((spinBox1->value()*1000) + (spinBox2->value()*10));
}
