/*
 * qorientationcapability.h
 * author: Timo Härkönen
 */

#ifndef QORIENTATIONCAPABILITY_H
#define QORIENTATIONCAPABILITY_H

#include "../global/global.h"

#include <QObject>
#include <QtCore>
#include <QtGui/QWidget>

namespace Maemo {

    enum QOrientation {
        Landscape = 0,
        Portrait
    };

class QOrientationCapabilityPrivate;

class QHILDONWIDGETCAPABILITIES_SHARED_EXPORT QOrientationCapability : public QObject {
    Q_OBJECT
    Q_PROPERTY(bool listensForOrientationChanges READ isListeningOrientationChanges WRITE setListeningForOrientationChanges);

    MAEMO_DECLARE_PRIVATE(QOrientationCapability);

public:

    QOrientationCapability(QWidget* parent, bool automaticOrientationUpdate = false);
    ~QOrientationCapability();

    QOrientation orientation() const;
    bool isListeningOrientationChanges() const;

signals:
    void orientationChanged(QOrientation orientation);

public slots:
    void setListeningForOrientationChanges(bool enabled);
    void setOrientation(QOrientation orientation);

private slots:
    void orientationUpdate(const QString& orientation, const QString& stand, const QString& face);
};

} //Namespace
#endif // QORIENTATIONCAPABILITY_H
