/*
 *  qorientationinfo.cpp
 *  author: Timo Härkönen
 */

#include "qorientationinfo.h"
#include "qorientationinfo_p.h"
#include "moc_qorientationinfo.cpp"

namespace Maemo {

QOrientationInfo *QOrientationInfo::m_instance = 0;

QOrientationInfo::QOrientationInfo(QObject *parent) :
    QObject(parent)
{
    MAEMO_INITIALIZE(QOrientationInfo);
}

QOrientationInfo::~QOrientationInfo()
{
    MAEMO_UNINITIALIZE(QOrientationInfo);
}

QOrientationInfo *QOrientationInfo::instance()
{
    if(!m_instance) {
        m_instance = new QOrientationInfo();
    }

    return m_instance;
}

void QOrientationInfo::orientationUpdate(const QString &rotation, const QString &stand, const QString &face, int x, int y, int z)
{
    MAEMO_PRIVATE(QOrientationInfo);
    priv->orientationUpdate(rotation, stand, face, x, y, z);
}

void QOrientationInfo::startListening()
{
    MAEMO_PRIVATE(QOrientationInfo);
    priv->startListening();
}

void QOrientationInfo::stopListening()
{
    MAEMO_PRIVATE(QOrientationInfo);
    priv->stopListening();
}

bool QOrientationInfo::isListening() const
{
    MAEMO_PRIVATE_CONST(QOrientationInfo);
    return priv->isListening();
}

} //namespace
