/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#ifndef IGPS_H
#define IGPS_H

#include "CTrack.h"
#include <QObject>
#include <QDateTime>

#define N_OF_SATELLITES     12
#define SATELLITES_MAX_PRN  40

class IGps : public QObject
{
    Q_OBJECT;
    public:
        IGps(QObject * parent);
        virtual ~IGps();

        enum src_e {eNoGps, eNMEA, eNMEAMtk, eGpsd, eNokia};
        enum fix_e {eNoFix, e2DFix, e3DFix};
        enum dev_e {eSerial, eBluetooth};

        struct sat_t
        {
            int prn;
            int ele;
            int azi;
            int snr;
        };

        static IGps& self(){return *m_self;}

        fix_e getFix(){return fix;}
        fix_e getPosition(qreal& x, qreal& y) {
            x = lon;
            y = lat;
            return fix;
        }
        fix_e getElevation(qreal& e){e = ele; return fix;}
        fix_e getError(float& h, float& v){h = hdop; v = vdop; return fix;}

        fix_e getTrackPoint(STrackPoint& trkpt);
        fix_e getExt1Data(STrackExt1& trkpt);

        const QString& getSysError(){return sysError;}
        const QDateTime& getDateTime(){return datetime;}
        int getSatellites(const sat_t* & p){p = satellites; return idxSat;}
        qreal getVelocity(){return velocity;}
        qreal getHeading(){return heading;}

        signals:
        void sigNewData(IGps& gps);

    protected:
        static IGps * m_self;

        int baud;
        src_e src;

        QDateTime datetime;
        quint32 timestamp;
        fix_e   fix;
        qreal   lon;             ///< [rad]
        qreal   lat;             ///< [rad]
        qreal   ele;             ///< [m]
        qreal   hdop;
        qreal   vdop;
        qreal   velocity;        ///< [m/s]
        qreal   heading;         ///< [T]

        sat_t satellites[N_OF_SATELLITES];
        int idxSat;

        QString sysError;
};
extern IGps gpsDefault;
#endif                           //IGPS_H
