/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#ifndef CNOKIA_H
#define CNOKIA_H

#include <qmobilityglobal.h>
#include "IGps.h"

#include <QThread>
#include <QFile>
#include <QTextStream>
#include <QGeoSatelliteInfoSource>
#include <QGeoSatelliteInfo>

class QTimer;

QTM_BEGIN_NAMESPACE
class QGeoPositionInfo;
class QGeoPositionInfoSource;
QTM_END_NAMESPACE

QTM_USE_NAMESPACE

class CNokia : public IGps
{
    Q_OBJECT;
    public:
        CNokia(const QString& device, int rate, QObject * parent);
	static CNokia& self(){return *m_self;}
        virtual ~CNokia();
        virtual void decode(const QString& line);
        virtual void encode(const QString& line);
        virtual void portChanged(){};
    private:
        QGeoPositionInfoSource *location;
        QGeoSatelliteInfoSource *satelliteInfo;
	static CNokia * m_self;

    private slots:
        void slotWatchdog();
        void positionUpdated(const QGeoPositionInfo &info);
        void slotSatellitesInView(QList<QGeoSatelliteInfo> sats);

    protected:
        void terminateCommWait();
        QString line;
        QTimer * watchdog;
        bool haveSeenData;

};
#endif                           //CNOKIA_H
