/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#ifndef CNMEA_H
#define CNMEA_H

#include "IGps.h"
#ifdef WINCE
#include <qserialportce.h>
#else
#include <qserialport.h>
#endif

class QTimer;

class CNMEA : public IGps
{
    Q_OBJECT;
    public:
        CNMEA(const QString& device, int rate, QObject * parent);
        virtual ~CNMEA();

        virtual void decode(const QString& line);
        virtual void encode(const QString& line);
        virtual void portChanged(){};

    private slots:
        void slotReadyRead();
        void slotWatchdog();

    protected:
        QSerialPort port;
        QString line;
        QTimer * watchdog;

        bool haveSeenData;
};
#endif                           //CNMEA_H
