/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CMAPDB_H
#define CMAPDB_H

#include "IDB.h"

#include <QPointer>
#include <QPixmap>
#include <QSqlDatabase>
#include <QList>

class QPainter;
class IMap;
class QSize;
class QPoint;

class CMapDB : public IDB
{
    Q_OBJECT;
    public:
        virtual ~CMapDB();

        static CMapDB& self(){return *m_self;}

        struct map_list_item_t
        {
            int id;
            QString name;
        };

        /// get reference to current active map object
        IMap& getMap();
        /// draw current active map
        void draw(QPainter& p, const QRectF& viewport);
        /// resize viewport
        void resize(const QSize& s);
        /// move viewport
        void move(const QPoint& old, const QPoint& next);
        /// change zoom level
        void zoom(bool in);
        /// change zoom level, and center to pos
        void zoom(bool in, const QPointF& pos);
        /// get current used zoom level
        int getZoomLevel(){return zoomidx;}
        /// simply get a list with file names and their database id
        void getAvailableMaps(QList<map_list_item_t>& maps);

        QRectF getViewport();

        signals:
        /// emitted when ever the database is changed
        void sigChanged();

    public slots:
        /// call this to rebuild the database
        void slotRebuildDB();

    private slots:
        void slotDestroyDetailMap();

    private:
        friend class CCanvas;
        CMapDB(QObject * parent);
        /// update overlay pixmap buffer1
        /**
            Call every time the viewport ore database is changed.
        */
        void updateOverlays();

        static CMapDB * m_self;

        /// the database file path
        QString dbName;
        /// use this database object exclusively
        QSqlDatabase db;
        /// the pointer to the current active detailed map
        QPointer<IMap> theMap;
        /// the default world map
        QPointer<IMap> defaultMap;

        /// the current zoom index into IMap::scales
        int zoomidx;
        /// the center point in [px]
        QPoint center;
        /// overlay buffer to show all database dependent data
        QPixmap buffer1;
};
#endif                           //CMAPDB_H
