/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#ifndef CGPSD_H
#define CGPSD_H

#include "IGps.h"
#ifdef WINCE
#include <windows.h>
#include <gpsapi.h>
#endif
#include <QThread>
#include <QFile>
#include <QTextStream>
class QTimer;
class Win_GpsThread;

class CGpsd : public IGps
{
    Q_OBJECT;
    //friend class Win_GpsThread;
    public:
        CGpsd(const QString& device, int rate, QObject * parent);
        virtual ~CGpsd();
        void gpsReadData(GPS_POSITION gps_position);
        virtual void decode(const QString& line);
        virtual void encode(const QString& line);
        virtual void portChanged(){};
    private:
        HANDLE m_hGPS_Device;    //Device handle
                                 //Event for location data updates
        HANDLE m_hNewLocationData;

    private slots:
        void slotWatchdog();
        void slotGpsRead();

    protected:
        Win_GpsThread * gpsdThread;
        void terminateCommWait();
        QString line;
        QTimer * watchdog;
        bool haveSeenData;

};

/*!
 * This thread monitors communication events.
 */
class Win_GpsThread: public QThread
{
    Q_OBJECT;
    public:
        /*!
         * Constructor.
         *
         * \param qesp valid serial port object.
         */
        Win_GpsThread(CGpsd * caller);
        HANDLE thehGPS;          //Device handle
                                 //Event for location data updates
        HANDLE thehNewLocationData;
        GPS_POSITION gps_Position;
        CGpsd * caller;
        bool terminate;
        /*!
         * Stop the thread.
         */
        void stop();

    protected:
        //overriden
        virtual void run();
        void monitorGpsdEvent();

        signals:
        void sigGpsRead();
};
#endif                           //CGPSD_H
