
#include "CDlgTransfer.h"
#include "CCanvas.h"

#include <QtGui>

CDlgTransfer::CDlgTransfer(QWidget *parent) :
    QWidget(parent)
{
    setupUi(this);
    hide();
    statusText->setText("");
}

CDlgTransfer::~CDlgTransfer()
{

}

void CDlgTransfer::paintEvent(QPaintEvent * e)
{
    QPainter p;
    p.begin(this);
    draw(p);
    p.end();

    QWidget::paintEvent(e);
}

void CDlgTransfer::draw(QPainter& p)
{
    QRect r = frameGeometry();
    r.moveTo(0,0);
    r.setWidth(r.width() - 1);
    r.setHeight(r.height() - 1);

    p.setBrush(QBrush(QColor(255,220,220,220)));
    p.setPen(Qt::black);
    p.drawRect(r);
}


void CDlgTransfer::update(const QString& msg)
{
    statusText->setText(msg);
}

void CDlgTransfer::mode(int type)
{
    QPixmap pix;
    switch (type) {
      case 5:
      case 6:
      case 7: pix.load(":/icons/waypoint16x16.png");
              break;
      case 8:
      case 9:
      case 10: pix.load(":/icons/track16x16.png");
               break;
      default: pix.load(":/icons/globe16x16.png");
    }
    pix = pix.scaled(16,16);
    icon->setPixmap(pix);
}
