/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CDLGEDIT_H
#define CDLGEDIT_H

#include <QDialog>
#include "ui_IDlgEdit.h"

class QTextEdit;
class QLineEdit;

class CDlgEdit : public QDialog, Ui::IDlgEdit
{
    Q_OBJECT;
    public:
        CDlgEdit(QWidget * parent);
        virtual ~CDlgEdit();

    private slots:
        void slotKeyPressed();
        void slotOk();
        void slotCancel();
        void slotSpace();

    protected:
        bool eventFilter(QObject *obj, QEvent *event);

    private:
        enum key_e {eCapsLock, eNoCaps, eSym};
        QLineEdit * lineEdit;
        QTextEdit * textEdit;

        bool singelShift;
};

#endif //CDLGEDIT_H

