/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#include "IGps.h"

#include <projects.h>
#include <QtGui>

IGps * IGps::m_self = 0;
IGps gpsDefault(0);

IGps::IGps(QObject * parent)
: QObject(parent)
, baud(4800)
, src(eNoGps)
, fix(eNoFix)
, lon(0)
, lat(0)
, ele(0)
, hdop(50.0)
, vdop(50.0)
, velocity(0.0)
, heading(0.0)
, idxSat(0)
, sysError(tr("No GPS device."))
{
    memset(satellites,0,sizeof(satellites));
    m_self = this;

    qDebug() << "IGps::IGps(QObject * parent)";
}


IGps::~IGps()
{
    m_self = &gpsDefault;
    qDebug() << "IGps::~IGps()";
}

IGps::fix_e IGps::getTrackPoint(STrackPoint& trkpt)
{
    trkpt.lon       = lon;
    trkpt.lat       = lat;
    trkpt.ele       = ele;
    trkpt.timestamp = timestamp;

    return fix;
}

IGps::fix_e IGps::getExt1Data(STrackExt1& trkpt)
{
//    trkpt.altitude  = altitude;
//    trkpt.height    = height;
    trkpt.velocity  = velocity;
    trkpt.heading   = heading;

//    trkpt.magnetic  = magnetic;
    trkpt.vdop      = vdop;
    trkpt.hdop      = hdop;

//    trkpt.pdop      = pdop;
//    trkpt.x         = x;
//    trkpt.y         = y;
//    trkpt.z         = z;
//    trkpt.vx        = vx;
//    trkpt.vy        = vy;
//    trkpt.vz        = vz;

    return fix;
}
