/**********************************************************************************************
    Copyright (C) 2008 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CPROTOCOL_H
#define CPROTOCOL_H

#include <QObject>

class QTcpSocket;

class CProtocol : public QObject
{
    Q_OBJECT;
    public:
        CProtocol(QTcpSocket * socket);
        virtual ~CProtocol();

        enum packet_e
        {
            eNone           = 0
            , eError        = 1     ///< error occured
            , eAck          = 2     ///<
            , eC2HAlive     = 3
            , eH2CAlive     = 4
            , eC2HWpt       = 5     ///< send waypoint data from client (GT) to host (M)
            , eH2CWptQuery  = 6     ///< request waypoint keys from host (M)
            , eH2CWpt       = 7     ///< request waypoint data from host (M)
            , eH2CTrkQuery  = 8     ///< request track keys from host (M)
            , eH2CTrk       = 9     ///< request track data from host (M)
            , eC2HTrk       = 10    ///< send track data from from client (GT) to host (M)
            , eH2CScreen    = 11 ///< request screenshot from host (M)
        };

    signals:
        void sigStatus(const QString& msg);
        void sigType(int type);

    private slots:
        void slotReadyRead();

    private:
        void send(const packet_e type, const QByteArray& data);
        bool recv(packet_e& type, QByteArray& data);

        QTcpSocket * socket;
        const int timeout;


};
#endif                           //CPROTOCOL_H
