/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CMAPRASTER_H
#define CMAPRASTER_H

#include "IMap.h"

#include <projects.h>
#include <QVector>
#include <QRgb>
#include <QRectF>

class GDALDataset;

#define MAX_SCALE_OFFSET        4

class CMapRaster : public IMap
{
    Q_OBJECT;
    public:
        CMapRaster(const QString& filename, QObject * parent);
        virtual ~CMapRaster();

        bool isValid(){return (dataset != 0);}

        void convertRad2Pt(qreal& x, qreal& y);

        void convertPt2Rad(qreal& x, qreal& y);

        static bool readHeader(const QString& filename, QPointF& ref1, QPointF& ref2, qint32& zmin, qint32& zmax);
    protected:
        void resize(const QSize& size);
        void draw(QPainter& p);
        void move(const QPoint& old, const QPoint& next);
        int zoom(int idx);

        /// the zoom factor derived from the zoom index
        qreal zoomfactor;
        /// the x axis scale of the map [rad/px]
        qreal xscale;
        /// the y axis scale of the map [rad/px]
        qreal yscale;
        /// x left viewport border [rad]
        qreal x;
        /// x top viewport border [rad]
        qreal y;

        /// horizontal size in [px]
        quint32 xsize;
        /// vertical size in [px]
        quint32 ysize;

        /// top left map border in [rad]
        qreal xref1;
        /// top left map border in [rad]
        qreal yref1;
        /// bottom right map border in [rad]
        qreal xref2;
        /// bottom right map border in [rad]
        qreal yref2;

        /// the areas covered by ref1 to ref2
        QRectF maparea;
        /// instance of GDAL dataset
        GDALDataset * dataset;
        /// QT representation of the GeoTiff's color table
        QVector<QRgb> colortable;

        qint32 bestScale;

        /// x center of viewport in [px]
        qreal xCenter;
        /// y center of viewport in [px]
        qreal yCenter;

    private:
        void draw();
};
#endif                           //CMAPRASTER_H
