/**********************************************************************************************

  DSP Solutions GmbH & Co. KG
  http://www.dspsolutions.de/

  Author:      Not defined
  Email:       Not defined
  Phone:       Not defined
  Fax:         +49-941-83055-79

  File:        CDlgWptDel.cpp

  Module:

  Description:

  Created:     10/12/2009

  (C) 2009 DSP Solutions. All rights reserved.


**********************************************************************************************/

#include "CDlgWptDel.h"
#include "CWptDB.h"
#include "WptIcons.h"

#include <QtGui>

CDlgWptDel::CDlgWptDel(QWidget * parent)
: QDialog(parent)

{
    setupUi(this);
    setupKeys(this);
    setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Dialog);
    setAttribute(Qt::WA_DeleteOnClose, false);
    show();

    pushKey1->setText(tr("ok"));
    connect(pushKey1, SIGNAL(clicked()), this, SLOT(slotKey1()));
    pushKey2->setText(tr("cancel"));
    connect(pushKey2, SIGNAL(clicked()), this, SLOT(slotKey2()));
    pushKey3->setText(tr(""));
    connect(pushKey3, SIGNAL(clicked()), this, SLOT(slotKey3()));
    pushKey4->setText(tr(""));
    connect(pushKey4, SIGNAL(clicked()), this, SLOT(slotKey4()));

#ifdef WINCE

#else
    spacerKeyboard->changeSize(20,0,QSizePolicy::Fixed,QSizePolicy::Fixed);
#endif

    QString errmsg;
    QSet<QString> icons;
    if(!CWptDB::self().getUsedIcons(icons, errmsg)){
        qDebug() << errmsg;
    }

    QListWidgetItem * item = new QListWidgetItem(listWptIcons);
    item->setText(tr("--- delete all icons---"));

    QString icon;
    foreach(icon, icons){
        QListWidgetItem * item = new QListWidgetItem(listWptIcons);
        item->setText(icon);
        item->setIcon(getWptIconByName(icon));
    }

    listWptIcons->sortItems();
}

CDlgWptDel::~CDlgWptDel()
{

}

void CDlgWptDel::slotKey1()
{
    QString errmsg;
    QListWidgetItem * item = listWptIcons->currentItem();
    if(item){
        QString icon = item->text();

        QMessageBox::StandardButton res = QMessageBox::question(this, tr("Delete waypoint..."), tr("Really delete: %1").arg(icon), QMessageBox::Ok|QMessageBox::Cancel, QMessageBox::Ok);
        if(res != QMessageBox::Ok){
            return;
        }

        if(icon == tr("--- delete all icons---")){
            CWptDB::self().del("*", errmsg);
        }
        else{
            CWptDB::self().delByIcon(icon, errmsg);
        }
        if(!errmsg.isEmpty()) qDebug() << errmsg;

        done(0);
    }
    else{
        return;
    }
}

void CDlgWptDel::slotKey2()
{
    done(-1);
}

void CDlgWptDel::slotKey3()
{
}

void CDlgWptDel::slotKey4()
{
}
