/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CDlgWpt.h"
#include "CWptDB.h"
#include "WptIcons.h"

#include <QtGui>

CDlgWpt::CDlgWpt(QWidget * parent)
: QWidget(parent)
{
    setupUi(this);
    connect(&CWptDB::self(), SIGNAL(sigChanged()), this, SLOT(slotDBChanged()));

    slotDBChanged();


    if(listWpts->count()){
        listWpts->setCurrentItem(listWpts->item(0));
    }
    listWpts->setFocus();
}

CDlgWpt::~CDlgWpt()
{

}

void CDlgWpt::slotDBChanged()
{
    QStringList keys, names, icons;
    QString errmsg;

    CWptDB::self().list(keys, names, icons, errmsg);

    listWpts->clear();

    for(int i = 0; i < keys.count(); ++i){
        QListWidgetItem * item = new QListWidgetItem(listWpts);
        item->setText(names[i]);
        item->setData(Qt::UserRole, keys[i]);
        item->setIcon(getWptIconByName(icons[i]));
    }
    listWpts->sortItems();
}

QString CDlgWpt::getCurrentKey()
{
    QString key;

    QListWidgetItem * item = listWpts->currentItem();
    if(item){
        key = item->data(Qt::UserRole).toString();
    }

    return key;
}
