/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#ifndef CCANVAS_H
#define CCANVAS_H

#include <QWidget>
#include <QPointer>
#include <QSqlDatabase>
#ifdef NOKIA
#include <qmobilityglobal.h>
//#include <QtDBus>
//#include <QtMaemo5>
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
#endif

#ifdef DISPLAY_NOKIA
#include<ui_ICanvas_Nokia.h>     // Display_Nokia
#elif DISPLAY_SMALL
#include<ui_ICanvas_small.h>
#else                            //DISPLAY_SMALL
#include<ui_ICanvas_large.h>
#endif                           //DISPLAY_SMALL

#include "IGps.h"
#include "IKeys.h"

#define DB_VERSION "1.2"

class IUnit;
class CMapDB;
class CWptDB;
class CTrackDB;
class CTransferAgent;
class CBacklight;
class CDlgTransfer;
class CDlgEdit;
class CMenu;

QTM_BEGIN_NAMESPACE
class QOrientationFilter;
class QOrientationReading;
QTM_END_NAMESPACE

QTM_USE_NAMESPACE


class CCanvas : public QWidget, public IKeys, private Ui::ICanvas
{
    Q_OBJECT;
    public:
        virtual ~CCanvas();
        static CCanvas& self(){return *m_self;}

        void setGPS(IGps::src_e src, const QString& port, int baudrate, IGps::dev_e dev, const QString& name, const QString& mac);

        CDlgTransfer& getDlgTransfer();

        enum cursormode_e
        {
            eLocked
            ,eUser
        };

        /// get current gps position
        int getCurrentPos(qreal& x, qreal& y, qreal &ele);

        /// activate user cursor and move it to position
        void setUsrPos(const qreal lon, const qreal lat);

        /// lock canvas for all user interaction  (backlight off mode)
        void lock(bool yes);

        /// static helper to draw text with white border
        static void drawText(const QString& str, QPainter& p, const QPoint& center, const QColor& color);

        /// flag to signal the use of large icons
        /**
            This can be modified and read by anyone. You may interpret it as you want.
            E.g. CWptDB will draw 32x32 icons instead of 16x16 ones if set true.

        */
        bool largeIcons;

    signals:
        void sigNewGps(IGps * gps);
        void sigUsrPos(const QPointF& pos, qint32 mode);

    protected:
        void paintEvent(QPaintEvent * e);
        void resizeEvent(QResizeEvent * e);

        void mouseMoveEvent(QMouseEvent * e);
        void mousePressEvent(QMouseEvent * e);
        void mouseReleaseEvent(QMouseEvent * e);

        bool eventFilter(QObject *obj, QEvent *event);
    private slots:
        void slotKey1();
        void slotKey2();
        void slotKey3();
        void slotKey4();
        void slotNewGpsData(IGps& gps);
        void slotContentChanged();
        void enterUserMode();
        void leaveUserMode();
        //void orientationChanged(const QString &newOrientation);

    private:
        friend int main(int argc, char ** argv);
        CCanvas();

        void drawCursor(QPainter& p);

        void drawBacklightCtrl(QPainter& p);

        void setUsrPos(const QPoint& pos);

        /// the one and only instance
        static CCanvas * m_self;
        /// set to true if all initialization is done
        bool initialized;
        /// the currently used gps device
        QPointer<IGps> gps;
        /// the current active unit translator
        QPointer<IUnit> unit;
        /// the map database
        CMapDB * dbMap;
        /// the waypoint database
        CWptDB * dbWpt;
        /// the waypoint database
        CTrackDB * dbTrack;
        /// current gps position in [px]
        QPointF gpsPos;
        QPointF usrPos;
        /// inner canvas area with no map movement
        QRect  innerArea;

        QPixmap buffer;

        bool needRedraw;

        cursormode_e cursorMode;

        bool moveMap;

        QPoint usrPosPixel;

        CTransferAgent * transferAgent;

        CBacklight * backlight;

        CDlgEdit * dlgEdit;

        /// the database file path
        QString dbName;

        /// use this database object exclusively
        QSqlDatabase db;

        bool lockInterface;

};
#endif                           //CCANVAS_H
