/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#include "CNokia.h"
#include <QtGui>
#include <projects.h>

CNokia * CNokia::m_self = 0;
LocationGPSDevice *callback_device  = 0;

#define MAX_WAIT    5000
#define MAX_AGE     1000

extern "C" {
    static void on_error(LocationGPSDControl *control, LocationGPSDControlError error, gpointer data)
    {
            g_debug("location error: %d... quitting", error);
            g_main_loop_quit((GMainLoop *) data);
    }

    static void on_changed(LocationGPSDevice *device,  gpointer data)
    {
            if (!device)
                    return;
	    CNokia::self().slotGpsRead(device);
    }

    static void on_stop(LocationGPSDControl *control, gpointer data)
    {
            g_debug("quitting");
            g_main_loop_quit((GMainLoop *) data);
    }

    static gboolean start_location(gpointer data)
    {
            location_gpsd_control_start((LocationGPSDControl *) data);
            return FALSE;
    }
}

CNokia::CNokia(const QString& gpsdevice, int rate, QObject * parent)
: IGps(parent)
, haveSeenData(false)
{
    m_self = this;
    watchdog = new QTimer(this);
    connect(watchdog, SIGNAL(timeout()), this, SLOT(slotWatchdog()));
    qDebug() << "CNokia::CNokia";
    memset(satellites,0,sizeof(satellites));

    sysError = tr("Start Location device.");
    qDebug() << "CNokia::CNokia watchdog";

    g_type_init();

    loop = g_main_loop_new(NULL, FALSE);
    qDebug() << "CNokia::CNokia main_loop";

    control = location_gpsd_control_get_default();
    device = (LocationGPSDevice*)g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);
    qDebug() << "CNokia::CNokia control get gpsd";

    g_object_set(G_OBJECT(control),
            "preferred-method", LOCATION_METHOD_USER_SELECTED,
            "preferred-interval", LOCATION_INTERVAL_DEFAULT,
            NULL);

    g_signal_connect(control, "error-verbose", G_CALLBACK(on_error), loop);
    g_signal_connect(device, "changed", G_CALLBACK(on_changed), (CNokia*)this);
    g_signal_connect(control, "gpsd-stopped", G_CALLBACK(on_stop), loop);
    qDebug() << "CNokia::CNokia control connect signal";

    g_idle_add(start_location, control);

    //g_main_loop_run(loop);
    watchdog->start(5000);
    qDebug() << "CNokia::CNokia end";

}


CNokia::~CNokia()
{
    location_gpsd_control_stop((LocationGPSDControl *) control);
    g_object_unref(device);
    g_object_unref(control);
}


void CNokia::decode(const QString& line)
{
}


void CNokia::encode(const QString& line)
{
}


void CNokia::slotGpsRead(LocationGPSDevice *device)
{
    // Fix type
    fix= device->fix->mode == LOCATION_GPS_DEVICE_MODE_3D ? e3DFix : device->fix->mode == LOCATION_GPS_DEVICE_MODE_2D ? e2DFix : eNoFix;
    if (device->satellites != NULL) {
       for ( idxSat = 0; idxSat < device->satellites->len; idxSat++) {
	    LocationGPSDeviceSatellite *dataSat = (LocationGPSDeviceSatellite*)g_ptr_array_index(device->satellites, idxSat);
            satellites[idxSat].prn = dataSat->prn;
            satellites[idxSat].ele = dataSat->elevation;
            satellites[idxSat].azi = dataSat->azimuth;
            satellites[idxSat].snr = dataSat->signal_strength;
       }
    }
    /*
    if (!(device->fix->fields & LOCATION_GPS_DEVICE_TIME_SET) || 
	!(device->fix->fields & LOCATION_GPS_DEVICE_LATLONG_SET)
    ) {
	return;
    }
    */
    if (device->fix->fields & LOCATION_GPS_DEVICE_LATLONG_SET) {
	    	lat = device->fix->latitude * DEG_TO_RAD;
	    	lon = device->fix->longitude * DEG_TO_RAD;
	    	hdop = device->fix->eph / 100 ;
	    	vdop = device->fix->epv;
    }
    if (device->fix->fields & LOCATION_GPS_DEVICE_TIME_SET) {
	    	timestamp = device->fix->time;
    }
    if (device->fix->fields & LOCATION_GPS_DEVICE_ALTITUDE_SET) {
	    	ele = device->fix->altitude;
    }
    if (device->fix->fields & LOCATION_GPS_DEVICE_TRACK_SET) {
	        heading = device->fix->track;
    }
    if (device->fix->fields & LOCATION_GPS_DEVICE_SPEED_SET) {
	        velocity = device->fix->speed;
    }
	    
    haveSeenData = true;
    emit sigNewData(*this);
    qApp->processEvents();
}


void CNokia::slotWatchdog()
{
    if((device != NULL) && haveSeenData) {
    	sysError = "";
        haveSeenData = false;
        return;
    }
    watchdog->stop();

    if((device == NULL)) {
        qDebug() << "void CNokia::slotWatchdog()";
    }

    fix = eNoFix;

    qDebug() << "void CNokia::slotWatchdog()";

    //sysError = tr("Try to start GPS.");
    emit sigNewData(*this);
    //location_gpsd_control_stop((LocationGPSDControl *) control);

    qApp->processEvents();

    //sysError = (device != NULL) ? "" : tr("Failed to start GPS. Retry...");
    //location_gpsd_control_start((LocationGPSDControl *) control);
    emit sigNewData(*this);

    (device != NULL) ? watchdog->start(10000) : watchdog->start(10000);
    portChanged();
}
