/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CMENU_H
#define CMENU_H

#include <QWidget>
#include <QEventLoop>
#include <QRect>
#include <QLabel>
#include <QDialog>

class QAction;

class CMenu : public QDialog
{
    Q_OBJECT;
    public:
        CMenu(QWidget * parent);
        virtual ~CMenu();

        QAction * exec(const QPoint pos);

// // tr("gps"), this, SLOT(leaveUserMode())
        QAction * addAction(int idx, const QString& text, const QIcon& icon, QObject * obj = 0, const QString& slot = "");

    protected:
        void paintEvent(QPaintEvent *e);
        void mouseMoveEvent(QMouseEvent *e);
        void mousePressEvent(QMouseEvent *e);
        void keyPressEvent(QKeyEvent *e);
        void hideEvent(QHideEvent *);

    private:
        struct sEntry {
            sEntry() : a(0){};
            QRect r;
            QAction * a;
        };


        void popup(const QPoint& pos);

        QEventLoop eventLoop;

        sEntry entries[9];

        sEntry * current;

};

#endif //CMENU_H

