/****************************************************************************
**
** Copyright (C) 2000-2006 TROLLTECH ASA. All rights reserved.
**
** This file is part of the Phone Edition of the Qtopia Toolkit.
**
** This software is licensed under the terms of the GNU General Public
** License (GPL) version 2.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef HTCBUTHANDLER_H
#define HTCBUTHANDLER_H

//#ifdef QT_QWS_HTCPHONE

#include <QObject>
#include <QWSKeyboardHandler>

struct htcInput {
    unsigned int   dummy1;
    unsigned int   dummy2;
    unsigned short type;
    unsigned short code;
    unsigned int   value;
};


class QSocketNotifier;
class htcButHandler : public QObject, public QWSKeyboardHandler
{
    Q_OBJECT
public:
    htcButHandler(const QString &device);
    ~htcButHandler();

private:
	QSocketNotifier *m_notify;
	int  Asic3FD;
	int  GpioFD;
	int  ExtFD;
	QString devName;
	QString paramName;
	bool shift;
	int setEnvDevice(const QString &keys);
	int setDevice(const QString& device, const QString& mode);
	void processEvent(htcInput event);
private Q_SLOTS:
	void readAsic3Keys();
	void readGpioKeys();
	void readExtKeys();
};

//#endif // QT_QWS_HTCPHONE

#endif // HTCBUTHANDLER_H
