/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "qimsysdeclarativeview.h"

#include <QtCore/QDir>
#include <QtGui/QApplication>
#ifdef QIMSYS_PLATFORM_MAEMO
#include <QtOpenGL/QGLWidget>
#endif
#include <QtDeclarative/QDeclarativeEngine>
#include <QtDeclarative/QDeclarativeContext>

class QimsysDeclarativeView::Private
{
public:
    Private(QimsysDeclarativeView *parent);

private:
    QString read(const QString &fileName);

private:
    QimsysDeclarativeView *q;
};

QimsysDeclarativeView::Private::Private(QimsysDeclarativeView *parent)
    : q(parent)
{
#ifdef QIMSYS_PLATFORM_MAEMO
    q->setViewport(new QGLWidget(q));
#endif
    q->setResizeMode(QDeclarativeView::SizeRootObjectToView);

#ifdef QIMSYS_APPLICATION_DIR_PATH
    QDir rootDir(QIMSYS_MACRO_TO_STRING2(QIMSYS_APPLICATION_DIR_PATH));
#else
    QDir rootDir = QApplication::applicationDirPath();
#endif
    // up to root dir
    for (int i = 0; i < QString(QIMSYS_MACRO_TO_STRING(QIMSYS_APP_PATH)).count(QLatin1Char('/')) + 1; i++) {
        rootDir.cdUp();
    }

    rootDir.cd(QLatin1String(QIMSYS_MACRO_TO_STRING(QIMSYS_IMPORTS_PATH)));

    q->engine()->addImportPath(rootDir.absolutePath());

    QDeclarativeContext *context = q->rootContext();
    context->setContextProperty("version", QApplication::applicationVersion());
    context->setContextProperty("lgpl", read(":/LICENSE.LGPL"));
    context->setContextProperty("lgpl_exception", read(":/LGPL_EXCEPTION.TXT"));

    connect(q->engine(), SIGNAL(quit()), q, SIGNAL(quit()));
}

QString QimsysDeclarativeView::Private::read(const QString &fileName)
{
    QString ret;
    QFile file(fileName);
    if (file.open(QFile::ReadOnly | QFile::Text)) {
        ret = file.readAll();
        file.close();
    } else {
        ret = file.errorString();
    }
    return ret;
}

QimsysDeclarativeView::QimsysDeclarativeView(QWidget *parent)
    : QDeclarativeView(parent)
{
    d = new Private(this);
//    connect(QApplication::desktop(), SIGNAL(workAreaResized(int)), this, SLOT(resetGeometry()));
//    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(resetGeometry()));
}

QimsysDeclarativeView::~QimsysDeclarativeView()
{
    delete d;
}

QUrl QimsysDeclarativeView::resolveUrl(const QString &path) const
{
#ifdef QIMSYS_APPLICATION_DIR_PATH
    QDir rootDir(QIMSYS_MACRO_TO_STRING2(QIMSYS_APPLICATION_DIR_PATH));
#else
    QDir rootDir = QApplication::applicationDirPath();
#endif
    // up to root dir
    for (int i = 0; i < QString(QIMSYS_MACRO_TO_STRING(QIMSYS_APP_PATH)).count(QLatin1Char('/')) + 1; i++) {
        rootDir.cdUp();
    }

    rootDir.cd(QLatin1String(QIMSYS_MACRO_TO_STRING(QIMSYS_DATA_PATH)));
    return QUrl(QString("%1/qml/%2").arg(rootDir.absolutePath()).arg(path));
}

bool QimsysDeclarativeView::event(QEvent *event)
{
//    switch (event->type()) {
//    case QEvent::RequestSoftwareInputPanel:
//        ui->actionShow_Keyboard->blockSignals(true);
//        ui->actionShow_Keyboard->setChecked(true);
//        ui->actionShow_Keyboard->blockSignals(false);
//        return true;
//    case QEvent::CloseSoftwareInputPanel:
//        ui->actionShow_Keyboard->blockSignals(true);
//        ui->actionShow_Keyboard->setChecked(false);
//        ui->actionShow_Keyboard->blockSignals(false);
//        return true;
//    default:
//        break;
//    }
    return QDeclarativeView::event(event);
}
