include(./qimsysplatform.pri)

defineReplace(cleanPath) {
    win32:1 ~= s|\\\\|/|g
    contains(1, ^/.*):pfx = /
    else:pfx =
    segs = $$split(1, /)
    out =
    for(seg, segs) {
        equals(seg, ..):out = $$member(out, 0, -2)
        else:!equals(seg, .):out += $$seg
    }
    return($$join(out, /, $$pfx))
}

QIMSYS_VERSION = 0.1.0
DEFINES += QIMSYS_VERSION=\\\"$$QIMSYS_VERSION\\\"
#VERSION = $$QIMSYS_VERSION

unix {
    macx {
        # disable dbus
        CONFIG *= no-dbus
    }
} else {
    # disable dbus
    CONFIG *= no-dbus
}
contains(CONFIG, no-dbus): DEFINES += QIMSYS_NO_DBUS

QIMSYS_APP_TARGET = qimsys

win32 {
    QIMSYS_LIBRARY_BASENAME = bin
    QIMSYS_PLUGIN_BASEPATH = plugins
} else {
    QIMSYS_LIBRARY_BASENAME = lib
    QIMSYS_PLUGIN_BASEPATH = $$QIMSYS_APP_TARGET/plugins
}

DEFINES += QIMSYS_LIBRARY_BASENAME=\\\"$$QIMSYS_LIBRARY_BASENAME\\\"

DEFINES += QIMSYS_PLUGIN_BASEPATH=\\\"$$QIMSYS_PLUGIN_BASEPATH\\\"

QIMSYS_SOURCE_TREE = $$PWD
isEmpty(QIMSYS_BUILD_TREE) {
    sub_dir = $$_PRO_FILE_PWD_
    sub_dir ~= s,^$$re_escape($$PWD),,
    QIMSYS_BUILD_TREE = $$cleanPath($$OUT_PWD)
    QIMSYS_BUILD_TREE ~= s,$$re_escape($$sub_dir)$,,
}

macx {
    QIMSYS_APP_PATH = $$QIMSYS_BUILD_TREE/bin
    QIMSYS_LIBRARY_PATH = $$QIMSYS_APP_PATH/$${QIMSYS_APP_TARGET}.app/Contents/PlugIns
    QIMSYS_PLUGIN_PATH = $$QIMSYS_LIBRARY_PATH
    QIMSYS_LIBEXEC_PATH = $$QIMSYS_APP_PATH/$${QIMSYS_APP_TARGET}.app/Contents/Resources
    QIMSYS_DATA_PATH = $$QIMSYS_APP_PATH/$${QIMSYS_APP_TARGET}.app/Contents/Resources
    QIMSYS_TRANSLATIONS_PATH = ../Resources/translations
    copydata = 1
} else {
    QIMSYS_APP_PATH = $$QIMSYS_BUILD_TREE/bin
    win32 {
        contains(TEMPLATE, vc.*)|contains(TEMPLATE_PREFIX, vc):vcproj = 1
        QIMSYS_TRANSLATION_PATH = translations
    }
    QIMSYS_LIBRARY_PATH = $$QIMSYS_BUILD_TREE/$$QIMSYS_LIBRARY_BASENAME
    QIMSYS_PLUGIN_PATH = $$QIMSYS_BUILD_TREE/$$QIMSYS_LIBRARY_BASENAME/$$QIMSYS_PLUGIN_BASEPATH
    QIMSYS_LIBEXEC_PATH = $$QIMSYS_APP_PATH
    QIMSYS_DATA_PATH = $$QIMSYS_BUILD_TREE/share/qimsys
    QIMSYS_TRANSLATIONS_PATH = ../share/qimsys/translations
    !isEqual(QIMSYS_SOURCE_TREE, $$QIMSYS_BUILD_TREE):copydata = 1
}

DEFINES += QIMSYS_DATA_PATH=\\\"$$QIMSYS_DATA_PATH\\\"
DEFINES += QIMSYS_TRANSLATIONS_PATH=\\\"$$QIMSYS_TRANSLATIONS_PATH\\\"


unix: {
    CONFIG(debug, debug|release):OBJECTS_DIR = $${OUT_PWD}/.obj/debug-shared
    CONFIG(release, debug|release):OBJECTS_DIR = $${OUT_PWD}/.obj/release-shared

    CONFIG(debug, debug|release):MOC_DIR = $${OUT_PWD}/.moc/debug-shared
    CONFIG(release, debug|release):MOC_DIR = $${OUT_PWD}/.moc/release-shared

    RCC_DIR = $${OUT_PWD}/.rcc
    UI_DIR = $${OUT_PWD}/.uic
}
