/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "candidatewindow.h"
#include "qimsysdebug.h"

#include "qimsyscandidates.h"

class CandidateWindow::Private : private QObject
{
    Q_OBJECT
public:
    Private(CandidateWindow *parent);
    ~Private();

private slots:
    void candidatesChanged(const QimsysConversionItemList &candidates);

private:
    CandidateWindow *q;
    QimsysCandidates candidates;
};

CandidateWindow::Private::Private(CandidateWindow *parent)
    : QObject(parent)
    , q(parent)
{
    candidates.init();
    connect(&candidates, SIGNAL(candidatesChanged(QimsysConversionItemList)), this, SLOT(candidatesChanged(QimsysConversionItemList)));
    connect(&candidates, SIGNAL(currentIndexChanged(int)), q, SLOT(setCurrentIndex(int)));
    connect(q, SIGNAL(currentIndexChanged(int)), &candidates, SLOT(setCurrentIndex(int)));
}

CandidateWindow::Private::~Private()
{
}

void CandidateWindow::Private::candidatesChanged(const QimsysConversionItemList &candidates)
{
    QStringList list;
    foreach(const QimsysConversionItem &c, candidates) {
        list.append(c.to);
    }
    q->setItems(list);
}

CandidateWindow::CandidateWindow(QObject *parent)
    : SimpleListWidget(qobject_cast<QWidget*>(parent))
{
    d = new Private(this);
}

CandidateWindow::~CandidateWindow()
{
    delete d;
}

#include "candidatewindow.moc"
