/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "languageobject.h"
#include "translator.h"
#include "languagesettings.h"
#include "qimsysdebug.h"

class LanguageObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(LanguageObject *parent);
    ~Private();

private:
    LanguageObject *q;
};

LanguageObject::Private::Private(LanguageObject *parent)
    : QObject(parent)
    , q(parent)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(All);
    TR(q, "categoryName", this, QT_TR_NOOP("Settings/Display Language"));

    q->setIcon(QIcon(":/languageicon.png"));
    TR(q, "name", this, QT_TR_NOOP("Display language"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "description", this, QT_TR_NOOP("This plugin is used to change display language."));
    TR(q, "translator", this, QT_TR_NOOP("NONE"));
}

LanguageObject::Private::~Private()
{
}

LanguageObject::LanguageObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

LanguageObject::~LanguageObject()
{
    delete d;
}

QimsysSettingsWidget *LanguageObject::settings(const QString &hint, QWidget *parent)
{
    return new LanguageSettings(this, parent);
}

#include "languageobject.moc"
