#ifndef QFLIPCLOCK_H
#define QFLIPCLOCK_H

#include <QWidget>
#ifdef QFLIPCLOCK_STANDALONE
#include <QMainWindow>
#endif
#include <QResizeEvent>
#include <QTimerEvent>
#include <QPaintEvent>
#include <QMouseEvent>
#include <QBasicTimer>

#include "sheet.h"
#include "theme.h"
#include "config.h"

#ifdef QFLIPCLOCK_WIDGET
class QFlipClock : public QWidget
#else
class QFlipClock : public QMainWindow
#endif
{
    Q_OBJECT

public:
#ifdef QFLIPCLOCK_WIDGET
    QFlipClock(QWidget *parent = 0);
#else
    QFlipClock(QMainWindow *parent = 0);
#endif
    ~QFlipClock();

    void updateTime(bool force = false);
    void setTransition(TransitionsEnum i);
#ifdef QFLIPCLOCK_WIDGET
    void setClickAction(ActionEnum i);
#endif
    void updateTheme();

    void startTimer();
    void stopTimer();

#ifdef QFLIPCLOCK_STANDALONE
    void toggleSize();
#endif

protected:
    void resizeEvent(QResizeEvent*);
    void timerEvent(QTimerEvent * event);
    void paintEvent(QPaintEvent *);
#ifdef Q_WS_MAEMO_5
    void mousePressEvent(QMouseEvent *);
#endif

private:
    QBasicTimer _ticker;
    Sheet *_hour;
    Sheet *_minute;

    TransitionsEnum _transition;
#ifdef QFLIPCLOCK_WIDGET
    ActionEnum _clickAction;
#endif
    qreal _aspect;
    qreal _xpad;
    qreal _gap;

    Theme * _theme;
    void reloadTheme();
};

#endif // QFLIPCLOCK_H
